/*
 *  clparse.h
 *
 *  The header file for a generic command line parser
 *
 *  Kekoa Proudfoot
 *  10/7/97
 */

#ifndef CLPARSE_H_DEFINED
#define CLPARSE_H_DEFINED

/*****************************************************************************
 * Type definitions
 *****************************************************************************/

typedef struct opt_t {
    char *option;
    int   index;
} opt_t;

/*****************************************************************************
 * Interface function declarations
 *****************************************************************************/

extern void clp_init(int argc, char **argv, opt_t *opts, int nopts);
extern int clp_getopt(void);
extern int clp_getint(void);
extern float clp_getfloat(void);
extern char *clp_getstring(void);
extern int clp_maybegetint(int failvalue);
extern float clp_maybegetfloat(float failvalue);
extern char *clp_maybegetstring(char *failvalue);
extern int clp_getpos(void);
extern int clp_geterror(void);
extern void clp_fail(char *format, ...);

#endif

