/*
 *  dump.c
 *
 *  Dumps a glt file as text
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <glt.h>

int
main(int argc, char **argv)
{
    GLT_trace trace;
    char *openname;
    char *filename;

    if (argc > 2)
        glt_fatal("usage: %s [filename]", argv[0]);

    openname = (argc == 2) ? argv[1] : NULL;
    filename = (argc == 2) ? argv[1] : "stdin";

    glt_open(&trace, openname, GLT_RDONLY | GLT_ERROK);

    /* The following is derived from code in glt_open */

    if (trace.flags & GLT_ERR)
        glt_warn("%s: not a valid GLT file", filename);
    else if (!(trace.flags & GLT_RSWAP) && trace.magic != GLT_MAGIC)
        glt_warn("%s: invalid magic number", filename);
    else if ((trace.flags & GLT_RSWAP) && trace.magic != GLT_SMAGIC)
        glt_warn("%s: invalid magic number", filename);
    else {
        char version[64], *buf = version;
        char magic[5] = { 0, 0, 0, 0, 0 };
        strncpy(magic, (char *)&trace.magic, 4);
        buf += sprintf(buf, "%s%snative trace, magic %s, version %u",
                       (trace.flags & GLT_GZIP) ? "gzipped " : "",
                       (trace.flags & GLT_RSWAP) ? "non-" : "",
                       magic, trace.version);
        if (trace.version < GLT_COMPAT)
            buf += sprintf(buf, " (min is %d)", GLT_COMPAT);
        else if (trace.version > GLT_VERSION)
            buf += sprintf(buf, " (max is %d)", GLT_VERSION);
        glt_warn("%s: %s", filename, version);
    }

    return 0;
}
