/*
 *  validate.c
 *
 *  Checks a glt file, prints the offset of any errors
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <glt.h>

char *
basename(char *path)
{
    char *last;
    last = strrchr(path, '/');
    if (!last)
        return path;
    else
        return last + 1;
}

int
main(int argc, char **argv)
{
    GLT_trace trace;
    GLT_data data;
    GLT_opcode op;
    char *progname;
    char *filename = NULL;
    unsigned int pos;
    unsigned int lastvalid = 0;

    progname = basename(argv[0]);

    if (argc > 2) {
        glt_fatal("usage: %s [filename]", progname);
    }

    if (argc == 2)
        filename = argv[1];

    glt_open(&trace, filename, GLT_RDONLY);

    if (filename)
        filename = basename(filename);
    else
        filename = "stdin";

    while (pos = glt_tell(&trace), op = glt_get(&trace, &data)) {
        lastvalid = pos;
        op = op;
    }

    if (glt_err(&trace))
        glt_fatal("%s: parse error at offset 0x%08x "
                  "(last valid 0x%08x)", filename, pos, lastvalid);
    else
        glt_warn("%s: ok", filename, pos);

    return 0;
}
