/*
 *  timer.h
 *
 *  Header file for timer routines.  Based on Q1/Q2 proxy timer code.
 *
 *  Kekoa Proudfoot
 *  6/25/98
 */

#ifndef TIMER_H_DEFINED
#define TIMER_H_DEFINED

#ifndef WIN32
#include <sys/time.h>
#else
#include <windows.h>
#include <sys/timeb.h>
#endif

#ifndef WIN32
typedef struct timeval timeval_t;
#else
typedef struct timeb timeval_t;
#endif

extern float timer_reset(timeval_t *timer);
extern float timer_read(timeval_t *timer);

#endif /* TIMER_H_DEFINED */
