/*
 *  timer.c
 *
 *  Generic timer routines.  Based on Q1/Q2 proxy timer code.
 *
 *  Kekoa Proudfoot
 *  6/25/98
 */

#ifndef WIN32
#include <sys/time.h>
#else
#include <windows.h>
#include <sys/timeb.h>
#endif

#include "timer.h"

#ifndef WIN32
#define tvupdate(tv)  gettimeofday(tv,NULL)
#define tvsec(tv)     ((tv)->tv_sec)
#define tvmsec(tv)    ((tv)->tv_usec * 1e-3)
#else
#define tvupdate(tv)  ftime(tv)
#define tvsec(tv)     ((tv)->time)
#define tvmsec(tv)    ((tv)->millitm)
#endif

float
timer_reset(timeval_t *timer)
{
    tvupdate(timer);
    return 0;
}

float
timer_read(timeval_t *timer)
{
    timeval_t now;
    tvupdate(&now);
    return tvsec(&now) - tvsec(timer) + (tvmsec(&now) - tvmsec(timer)) * 1e-3;
}
