/*
 *  dump.c
 *
 *  Dumps a glt file as text.
 *  Also dumps enums if that switch is activated.
 *
 *  Kekoa Proudfoot
 *  5/6/98, 6/25/98
 */

#include <stdio.h>
#include <stdlib.h>

#include <glt.h>

#include "timer.h"

#include <GL/gl.h>

/* Main */

#define PROGRESS_INTERVAL 30.0f

void
main(int argc, char **argv)
{
    GLT_trace trace;
    GLT_data data;
    GLT_opcode op;
    char *progname = argv[0];
    char *filename;
    int option;
    int maxbind = 0;
    int maxwidth = 0;
    int maxheight = 0;
    int frame = 0;
    timeval_t timer;

    argv++;
    argc--;

    if (argc > 1)
	glt_fatal("usage: %s [filename]", progname);

    glt_open(&trace, (argc == 1) ? argv[0] : NULL, GLT_RDONLY);

    filename = (argc == 1) ? argv[0] : "stdin";

    timer_reset(&timer);

    while (op = glt_get(&trace, &data)) {
	switch (op) {
	case GLT_OP_SWAP_BUFFERS:
	    frame++;
	    if (timer_read(&timer) > PROGRESS_INTERVAL) {
		glt_warn("%s: %d frames processed...", progname, frame);
		timer_reset(&timer);
	    }	    
	    break;
	case GLT_OP_BIND_TEXTURE:
	case GLT_OP_BIND_TEXTURE_EXT:
	    if (data.bind_texture.target == GL_TEXTURE_2D)
		if (data.bind_texture.texture > maxbind)
		    maxbind = data.bind_texture.texture;
	    break;
	case GLT_OP_TEX_IMAGE_2D:
	    if (data.tex_image_2d.width > maxwidth)
		maxwidth = data.tex_image_2d.width;
	    if (data.tex_image_2d.height > maxheight)
		maxheight = data.tex_image_2d.height;
	    break;
	}
    }
    if (glt_err(&trace)) {
	glt_warn("Parse error!");
	glt_warn("Error near file offset 0x%08x", glt_tell(&trace));
    }
    glt_warn("%s: max texture index %d, max width %d, max height %d",
	     filename, maxbind, maxwidth, maxheight);
}
