/*
 *  texformats.c
 *
 *  Checks a glt file, prints the offset of any errors
 *
 *  Kekoa Proudfoot
 *  2/8/99
 */

/* Don't need to search entire file before outputting formats if not sorting */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <glt.h>

#if 0
#define SHOW_BORDER
#endif

#if 1
#define FIXED_COLUMN_WIDTHS
#endif

char *
basename(char *path)
{
    char *last;
    last = strrchr(path, '/');
    if (!last)
        return path;
    else
        return last + 1;
}

#define MAX(a,b) (((a) > (b)) ? (a) : (b))

typedef struct {
    GLTint components;
    GLTint border;
    GLTenum format;
    GLTenum type;
} format_t;

int
cmp(const void *ap, const void *bp)
{
    const format_t *a = (const format_t *)ap;
    const format_t *b = (const format_t *)bp;

    if (a->format > b->format)
        return 1;
    if (a->format < b->format)
        return -1;
    if (a->type > b->type)
        return 1;
    if (a->type < b->type)
        return -1;
    if (a->components > b->components)
        return 1;
    if (a->components < b->components)
        return -1;
#ifdef SHOW_BORDER
    if (a->border > b->border)
        return 1;
    if (a->border < b->border)
        return -1;
#endif
    assert(0);

    return 0;
}

#define MAX_FORMATS 20000

#define FORMATHDR "format"
#define TYPEHDR "type"
#define COMPONENTSHDR "components"
#define BORDERHDR "border"

/* Hack! */
extern char *__glt_enum_name(GLTenum value);

int
main(int argc, char **argv)
{
    GLT_trace trace;
    GLT_data data;
    GLT_opcode op;
    char *progname;
    char *filename = NULL;
    format_t formats[MAX_FORMATS];
    int n_formats = 0;
    int i;
    int sort = 1;
    format_t widths = {1,1,1,1};
    char hdrfmt[64];

    /* Hack! */
    __glt_text_enums = 1;

    progname = basename(argv[0]);

    if (argc > 2) {
        glt_fatal("usage: %s [filename]", progname);
    }

    if (argc == 2)
        filename = argv[1];

    glt_open(&trace, filename, GLT_RDONLY);

    if (filename)
        filename = basename(filename);
    else
        filename = "stdin";

    while ((op = glt_get(&trace, &data))) {
        if (op == GLT_OP_TEX_IMAGE_2D) {
            format_t format;
            format.components = data.tex_image_2d.components;
#ifndef SHOW_BORDER
            format.border = 0;
#else
            format.border = data.tex_image_2d.border;
#endif
            format.format = data.tex_image_2d.format;
            format.type = data.tex_image_2d.type;
            for (i = 0; i < n_formats; i++)
                if (!memcmp(&format, &formats[i], sizeof(format_t)))
                    break;
            if (i == n_formats) {
                assert(n_formats < MAX_FORMATS);
                formats[n_formats++] = format;
            }
        }
    }

    if (glt_err(&trace))
        glt_warn("%s: parse error near file offset 0x%08x", filename,
                  glt_tell(&trace));

    if (!n_formats) {
        glt_warn("%s: no textures", filename);
        exit(0);
    }

    if (sort)
        qsort(formats, n_formats, sizeof(format_t), cmp);

    /* Find column widths */

    widths.format = strlen(FORMATHDR);
    widths.type = strlen(TYPEHDR);
    widths.components = strlen(COMPONENTSHDR);
    widths.border = strlen(BORDERHDR);

#ifdef FIXED_COLUMN_WIDTHS
    widths.format = MAX(widths.format, 20);
    widths.type = MAX(widths.type, 20);
    widths.components = MAX(widths.components, 30);
#else
    for (i = 0; i < n_formats; i++) {
        char buf[128];
        int len;

        len = strlen(__glt_enum_name(formats[i].format));
        if (len > widths.format)
            widths.format = len;

        len = strlen(__glt_enum_name(formats[i].type));
        if (len > widths.type)
            widths.type = len;

        len = strlen(__glt_enum_name(formats[i].components));
        if (len > widths.components)
            widths.components = len;

        sprintf(buf, "%d", formats[i].border);
        len = strlen(buf);
        if (len > widths.border)
            widths.border = len;
    }
#endif

#ifndef SHOW_BORDER
    sprintf(hdrfmt, "%%-%ds  %%-%ds  %%-%ds\n", widths.format,
            widths.type, widths.components);
#else
    sprintf(hdrfmt, "%%-%ds  %%-%ds  %%-%ds  %%-%ds\n", widths.format,
            widths.type, widths.components, widths.border);
#endif

    printf(hdrfmt, FORMATHDR, TYPEHDR, COMPONENTSHDR, BORDERHDR);
    for (i = 0; i < n_formats; i++) {
        char fstr[128];
        char tstr[128];
        char cstr[128];
        char bstr[128];

        strcpy(fstr, __glt_enum_name(formats[i].format));
        strcpy(tstr, __glt_enum_name(formats[i].type));

        if (formats[i].components < 5)
            sprintf(cstr, "%d", formats[i].components);
        else
            strcpy(cstr, __glt_enum_name(formats[i].components));

        sprintf(bstr, "%d", formats[i].border);

        printf(hdrfmt, fstr, tstr, cstr, bstr);
    }

    return 0;
}
