/*
 *  tex.c
 *
 *  A first crack at a texture viewer.
 *  This program is a complete hack, but what do you expect, it's for
 *  hacking.
 *
 *  Kekoa Proudfoot
 *  8/24/98
 */

/* Include files */

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include <GL/gl.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <glt.h>

#include "clparse.h"
#include "timer.h"

/* Global variables */

char *progname = "";

/* Hack! */

extern int __glt_text_enums;

/* Utility functions */

char *
basename(char *path)
{
    char *last;
    last = strrchr(path, '/');
    if (!last)
        return path;
    else
        return last + 1;
}

int win_width = 512;
int win_height = 512;

void
show_texture( int w, int h )
{
    int x, y;

    glClearColor(1.0, 1.0, 1.0, 1.0);
    glClear(GL_COLOR_BUFFER_BIT);

    glColor3f( 0.5f, 0.5f, 0.5f );
    for ( y = 0; y < win_height; y += 32 ) {
        for ( x = 0; x < win_width; x += 32 ) {
            glRecti( x, y, x+16, y+16 );
            glRecti( x+16, y+16, x+32, y+32 );
        }
    }

    glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
    glEnable( GL_BLEND );
    glEnable(GL_TEXTURE_2D);
    glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    glBegin(GL_QUADS);
    glTexCoord2f(0, 0);
    glVertex2i((win_width-w)/2, (win_height-h)/2);
    glTexCoord2f(0, 1);
    glVertex2i((win_width-w)/2, (win_height+h)/2);
    glTexCoord2f(1, 1);
    glVertex2i((win_width+w)/2, (win_height+h)/2);
    glTexCoord2f(1, 0);
    glVertex2i((win_width+w)/2, (win_height-h)/2);
    glEnd();
    glDisable( GL_TEXTURE_2D );
    glDisable(GL_BLEND);
}

/* Option table for command line parser */

enum {
    OPT_MIN,
    OPT_ONLY,
    OPT_SIZE
};

opt_t opts[] = {
    { "m",           OPT_MIN  },
    { "ms",          OPT_MIN  },
    { "min",         OPT_MIN  },
    { "minsize",     OPT_MIN  },
    { "o",           OPT_ONLY },
    { "only",        OPT_ONLY },
    { "s",           OPT_SIZE },
    { "size",        OPT_SIZE }
};

/* Main */

#define MAX_TEXTURES 4096

int
main(int argc, char **argv)
{
    GLT_trace    trace;
    GLT_data     data;
    GLT_opcode   op;
    char        *filename = NULL;
    int          option;
    int          only = -1;
    int          active;
    int min = 0;
    int w, h;
    char buf[64];
    int widths[MAX_TEXTURES];
    int heights[MAX_TEXTURES];
    int current = 0;

    __glt_text_enums = 1;

    /* Set progname */

    progname = basename(argv[0]);

    /* Parse command line */

    clp_init(argc, argv, opts, sizeof(opts) / sizeof(opt_t));

    while (!clp_geterror() && (option = clp_getopt()) >= 0) {
        switch (option) {
        case OPT_MIN:
            min = clp_getint();
            if (min <= 0)
                clp_fail("min size out of range");
            break;
        case OPT_ONLY:
            only = clp_getint();
            if (only < 0)
                clp_fail("texture index out of range");
            break;
        case OPT_SIZE:
            win_width  = clp_getint();
            win_height = clp_maybegetint(win_width);
            /* The following checks aren't strictly necessary */
            if (win_width <= 0)
                clp_fail("width out of range");
            if (win_height <= 0)
                clp_fail("height out of range");
            break;
        }
    }

    argv += clp_getpos();
    argc -= clp_getpos();

    /* Print usage on error */

    if (clp_geterror() || argc < 0 || argc > 1) {
        glt_warn("usage: %s [options] [filename]", progname);
        glt_warn("options:");
        glt_warn("    -only texture");
        glt_warn("    -size size");
        glt_warn("    -size width height");
        glt_warn("    -minsize size");
        exit(1);
    }

    active = (only < 0);

    /* Open the trace file */

    if (argc)
        filename = argv[0];

    glt_open(&trace, filename, GLT_RDONLY);

    /* Fetch commands and run them */

    while ((op = glt_get(&trace, &data))) {
        if (only >= 0)
            if (op == GLT_OP_BIND_TEXTURE || op == GLT_OP_BIND_TEXTURE_EXT)
                if (data.bind_texture.target == GL_TEXTURE_2D)
                    active = (data.bind_texture.texture == only);
        switch (op) {
        case GLT_OP_CREATE_CONTEXT:
        case GLT_OP_MAKE_CURRENT:
        case GLT_OP_BIND_TEXTURE:
        case GLT_OP_BIND_TEXTURE_EXT:
        case GLT_OP_TEX_IMAGE_2D:
        case GLT_OP_TEX_SUB_IMAGE_2D:
        case GLT_OP_TEX_SUB_IMAGE_2D_EXT:
            if (active) {
                printf("%s\n", glt_text(op, &data));
                fflush(stdout);
            }
            break;
        }
        switch (op) {
        case GLT_OP_CREATE_CONTEXT:
            glt_callgl(op, &data);
            break;
        case GLT_OP_MAKE_CURRENT:
            data.make_current.width = win_width;
            data.make_current.height = win_height;
            glt_callgl(op, &data);
            glMatrixMode(GL_PROJECTION);
            glLoadIdentity();
            glOrtho(0, win_width, 0, win_height, -1, 1);
            break;
        case GLT_OP_BIND_TEXTURE:
        case GLT_OP_BIND_TEXTURE_EXT:
            if (active)
                glt_callgl(op, &data);
            current = data.bind_texture.texture;
            break;
        case GLT_OP_TEX_IMAGE_2D:
        case GLT_OP_TEX_SUB_IMAGE_2D:
        case GLT_OP_TEX_SUB_IMAGE_2D_EXT:
            if (!active)
                break;
            glt_callgl(op, &data);
            assert(current < MAX_TEXTURES);
            if (op == GLT_OP_TEX_IMAGE_2D) {
                if (data.tex_image_2d.level != 0)
                    break;
                widths[current] = data.tex_image_2d.width;
                heights[current] = data.tex_image_2d.height;
                w = widths[current];
                h = heights[current];
                if (min) {
                    if (w > h) {
                        if (w < min) {
                            widths[current] = min;
                            heights[current] = h * min / w;
                        }
                    }
                    else {
                        if (h < min) {
                            widths[current] = w * min / h;;
                            heights[current] = min;
                        }
                    }
                }
            }
            if (op == GLT_OP_TEX_SUB_IMAGE_2D ||
                op == GLT_OP_TEX_SUB_IMAGE_2D) {
                if (data.tex_sub_image_2d.level != 0)
                    break;
            }
            w = widths[current];
            h = heights[current];
            show_texture( w, h );
            glt_callgl(GLT_OP_SWAP_BUFFERS, NULL);
            fgets(buf,sizeof(buf),stdin);
            break;
        default:
            break;
        }
    }

    /* Check for error condition */

    if (glt_err(&trace)) {
        glt_warn("Parse error!");
        glt_warn("Error near file offset 0x%08x", glt_tell(&trace));
    }

    glt_close(&trace);

    return 0;
}
