/*
 *  offsets.c
 *
 *  Dumps a glt file as text, with offsets
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include <glt.h>

int
main(int argc, char **argv)
{
    GLT_trace trace;
    GLT_data data;
    GLT_opcode op;
    char *progname;
    char *filename;
    int offset = 0;
    int usage = 0;
    int pos;

    progname = argv[0];
    argv++;
    argc--;

    if ((argc == 2) || (argc && argv[0][0] == '+')) {
        char *end;
        offset = strtol(argv[0], &end, 0);
        if (end == argv[0]) {
            glt_warn("%s: %s: invalid offset", progname, argv[0]);
            usage = 1;
        }
        argv++;
        argc--;
    }

    if (argc && argv[0][0]) {
        filename = argv[0];
        argv++;
        argc--;
    }
    else {
        filename = NULL;
    }

    if (argc || usage) {
        glt_warn("usage: %s [+]offset filename", progname);
        glt_fatal("usage: %s [+offset] [filename]", progname);
    }

    glt_open(&trace, filename, GLT_RDONLY);

    while (glt_tell(&trace) < offset) {
        glt_skip(&trace);
    }

    while (pos = glt_tell(&trace), op = glt_get(&trace, &data)) {
        printf("%08x: %s\n", pos, glt_text(op, &data));
    }

    if (glt_err(&trace)) {
        glt_warn("Parse error!");
        /* Hack! */
        glt_warn("Error at file offset 0x%08x", pos);
    }

    return 0;
}
