/*
 *  extract.c
 *
 *  A first crack at a context extractor.  Does not properly handle
 *  shared contexts.
 *
 *  Kekoa Proudfoot
 *  5/9/98
 */

/* Include files */

#include <stdio.h>
#include <stdlib.h>

#include <glt.h>

#include "clparse.h"

int
main(int argc, char **argv)
{
    GLT_trace    in;
    GLT_trace    out;
    GLT_data     data;
    GLT_opcode   op;
    char        *inname;
    char        *outname;
    int          context = 0;
    int          write = 0;

    /* Parse command line */

    clp_init(argc, argv, NULL, 0);

    context = clp_getint();
    inname = clp_maybegetstring(NULL);
    outname = clp_maybegetstring(NULL);

    if (clp_geterror() || argc > clp_getpos())
        glt_fatal("usage: %s context [infile [outfile]]", argv[0]);

    /* Open traces */

    glt_open(&in, inname, GLT_RDONLY);
    glt_open(&out, outname, GLT_WRONLY);

    /* Rename file names for stdio */

    if (!inname)
        inname = "stdin";
    if (!outname)
        outname = "stdout";

    /* Extract context - doesn't handle shared display lists, yet */

    if (context > 0) {
        while (( op = glt_get(&in, &data) )) {
            switch (op) {
            case GLT_OP_PAD:
                break;
            case GLT_OP_CREATE_CONTEXT:
                if (context == data.create_context.ctx)
                    glt_put(&out, op, &data);
                break;
            case GLT_OP_DESTROY_CONTEXT:
                if (context == data.destroy_context.ctx)
                    glt_put(&out, op, &data);
                break;
            case GLT_OP_MAKE_CURRENT:
                write = (context == data.make_current.ctx);
                if (write)
                    glt_put(&out, op, &data);
                break;
            default:
                if (write)
                    glt_put(&out, op, &data);
                break;
            }
        }
    }

    /* Check for error condition */

    if (glt_err(&in))
        glt_warn("%s: Parse error near file offset 0x%08x!", inname,
                 glt_tell(&in));

    /* Close traces */

    glt_close(&in);
    glt_close(&out);

    return 0;
}
