/*
 *  dump.c
 *
 *  Dumps a glt file as text.
 *  Also dumps enums if that switch is activated.
 *
 *  Kekoa Proudfoot
 *  5/6/98, 6/25/98
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#else
#include <unistd.h>
#endif

#include <glt.h>
#include "clparse.h"

char *progname;

char *
basename(char *path)
{
    char *last;
    last = strrchr(path, '/');
    if (!last)
        return path;
    else
        return last + 1;
}

/* Option table for command line parser */

enum { OPT_ENUMS, OPT_NO_PRIM, OPT_SEEKABLE, OPT_UNWIND, OPT_NUMBER };

opt_t opts[] = {
    { "e",       OPT_ENUMS   },
    { "enums",   OPT_ENUMS   },
    { "no-prim", OPT_NO_PRIM },
    { "unwind",  OPT_UNWIND  },
    { "N",       OPT_NUMBER  },
    { "number",  OPT_NUMBER  },
};

/* Main */

int
main(int argc, char **argv)
{
    GLT_trace trace;
    GLT_data data;
    GLT_opcode op;
    int option;
    int begin      = 0;
    int no_prim    = 0;
    int indent     = 0;
    int unwind     = 0;
    int number     = 0;
    int listdef    = 0;
    int command_number = 0;

    progname = basename(argv[0]);

    clp_init(argc, argv, opts, sizeof(opts) / sizeof(opt_t));
    while (!clp_geterror() && (option = clp_getopt()) >= 0) {
        switch (option) {
          case OPT_ENUMS:
            /* Hack! */
            __glt_text_enums = 1;
            break;
          case OPT_NO_PRIM:
            no_prim = 1;
            break;
          case OPT_UNWIND:
            unwind = 1;
            break;
          case OPT_NUMBER:
            number = 1;
            break;
        }
    }
    argv += clp_getpos();
    argc -= clp_getpos();

    if (clp_geterror() || argc > 1)
        glt_fatal("usage: %s [-enums] [-no-prim] [-unwind] [-number] "
                  "[filename]", progname);

    glt_open(&trace, (argc == 1) ? argv[0] : NULL,
             GLT_RDONLY | ( unwind ? (GLT_UNWIND|GLT_RETLIST) : 0 ) );

    command_number = 0;
    while ((op = glt_get(&trace, &data))) {

        if ( op == GLT_OP_END_LIST ) {
            indent -= 2;
            listdef = 0;
        }

        if ( op == GLT_OP_END )
            begin = 0;

        if ( !begin || !no_prim ) {
            int i;
            if ( number ) {
                if ( indent == 0 || listdef ) {
                    printf( "%-8d", command_number );
                    command_number++;
                } else {
                    fputs( "        ", stdout );
                }
            }
            for ( i = 0; i < indent; i++ )
                fputc( ' ', stdout );
            fputs( glt_text(op, &data), stdout );
            fputc( '\n', stdout );
        }

        if ( op == GLT_OP_BEGIN )
            begin = 1;

        if ( op == GLT_OP_NEW_LIST ) {
            indent += 2;
            listdef = 1;
        }

        if ( op == GLT_OP_CALL_LIST && unwind )
            indent += 2;
    }

    if (glt_err(&trace)) {
        glt_warn("Parse error!");
        glt_warn("Error near file offset 0x%08x", glt_tell(&trace));
    }

    return 0;
}
