/*
 *  counts.c
 *
 *  Counts opcodes in a glt file
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include <glt.h>

int counts[GLT_NUM_OPS];

int
cmp(const void *ap, const void *bp)
{
    GLT_opcode a = *(GLT_opcode *)ap;
    GLT_opcode b = *(GLT_opcode *)bp;
    int ac = counts[a];
    int bc = counts[b];

    if (bc > ac)
        return 1;
    if (bc < ac)
        return -1;
    return (a > b) - (a < b);
}

int
main(int argc, char **argv)
{
    GLT_trace trace;
    GLT_opcode op;
    GLT_opcode ops[GLT_NUM_OPS];
    int sort = 1;
    int i;
    if (argc > 2)
        glt_fatal("usage: %s [filename]", argv[0]);
    for (i = 0; i < GLT_NUM_OPS; i++) {
        ops[i] = i;
    }
    glt_open(&trace, (argc == 2) ? argv[1] : NULL, GLT_RDONLY);
    while (( op = glt_peek(&trace) )) {
        glt_skip(&trace);
        counts[op]++;
    }
    if (glt_err(&trace)) {
        glt_warn("Parse error!");
        glt_warn("Error near file offset 0x%08x", glt_tell(&trace));
    }
    if (sort)
        qsort(ops, GLT_NUM_OPS, sizeof(GLT_opcode), cmp);
    for (i = 0; i < GLT_NUM_OPS; i++) {
        GLT_opcode op = ops[i];
        if (counts[op])
            printf("%-10d %s\n", counts[op], glt_name(op));
    }

    return 0;
}
