/*
 *  copy.c
 *
 *  A program that reads and trace and copies it, so that the encode/decode
 *  routines can be tested for invariance.
 *
 *  Kekoa Proudfoot
 *  6/15/98
 */

/* Include files */

#include <stdio.h>
#include <stdlib.h>

#include <glt.h>

#include "clparse.h"

int
main(int argc, char **argv)
{
    GLT_trace    in;
    GLT_trace    out;
    GLT_data     data;
    GLT_opcode   op;
    char        *inname;
    char        *outname;

    /* Parse command line */

    clp_init(argc, argv, NULL, 0);

    inname = clp_maybegetstring(NULL);
    outname = clp_maybegetstring(NULL);

    if (clp_geterror() || argc > clp_getpos())
        glt_fatal("usage: %s [infile [outfile]]", argv[0]);

    /* Open traces */

    glt_open(&in, inname, GLT_RDONLY);
    glt_open(&out, outname, GLT_WRONLY);

    /* Rename file names for stdio */

    if (!inname)
        inname = "stdin";
    if (!outname)
        outname = "stdout";

    /* Read data and copy to output */

    while ((op = glt_get(&in, &data)))
        glt_put(&out, op, &data);

    /* Check for error condition */

    if (glt_err(&in))
        glt_warn("%s: Parse error near file offset 0x%08x!", inname,
                 glt_tell(&in));

    /* Close traces */

    glt_close(&in);
    glt_close(&out);

    return 0;
}
