/*
 *  dump.c
 *
 *  Dumps a glt file as text
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include <glt.h>

int
main(int argc, char **argv)
{
    GLT_trace trace;
    GLT_data data;
    GLT_opcode op;
    if (argc > 2)
        glt_fatal("usage: %s [filename]", argv[0]);
    glt_open(&trace, (argc == 2) ? argv[1] : NULL, GLT_RDONLY);
    while ((op = glt_peek(&trace))) {
        switch(op) {
        case GLT_OP_CREATE_CONTEXT:
        case GLT_OP_MAKE_CURRENT:
        case GLT_OP_DESTROY_CONTEXT:
            glt_get(&trace, &data);
            printf("%s\n", glt_text(op, &data));
            break;
        default:
            glt_skip(&trace);
        }
    }
    if (glt_err(&trace)) {
        glt_warn("Parse error!");
        glt_warn("Error near file offset 0x%08x", glt_tell(&trace));
    }

    return 0;
}
