#!/usr/common/bin/perl
#
# switch.pl
#
# Generates a C switch statement with cases for all GL opcodes
#
# Kekoa Proudfoot 5/10/98

use lib "../perl/modules";

# Bleah, I prefer Include qw(shared.in), but that gives errors until 5.004
use Includes;

use Opcodes qw(: @ops optofn fntolb);
use Flags   qw(: %ignore %noencode);

foreach $op (@ops) {
    $name = optofn($op);
    next if ($ignore{$name} || $noencode{$name});
    push(@names, $name);
}

print("/*\n");
print(" * Machine generated switch statement\n");
print(" *\n");
print(" */\n");
print("\n");

print("/* Include files */\n");
print("\n");

print("#include \"glt.h\"\n");
print("\n");

print("/* Macros */\n");
print("\n");

print("#ifndef NDEBUG\n");
print("#define ONCE(cmd) \\\n");
print("    do { \\\n");
print("        static int once = 0; \\\n");
print("        if (!once && ++once) cmd ; \\\n");
print("    } while (0)\n");
print("#else\n");
print("#define ONCE(cmd)\n");
print("#endif\n");
print("\n");

print("/* Ignore function */\n");
print("\n");

print("static void\n");
print("ignore(char *loc, char *func)\n");
print("{\n");
print("    glt_warn(\"%s: ignoring %s\", loc, func);\n");
print("}\n");
print("\n");

print("/* Switch statement */\n");
print("\n");

print("void\n");
print("func(GLT_opcode op, GLT_data *data)\n");
print("{\n");
print("    char *loc = \"func\";\n");
print("\n");

print("    switch (op) {\n");

foreach $name (@names) {
    $label = fntolb($name);

    print("    case $label:\n");
    print("        ONCE(ignore(loc, \"$name\"));\n");
    print("        break;\n");
}

print("    default:\n");
print("        glt_fatal(\"%s: invalid opcode %d\", loc, op);\n");
print("        break;\n");
print("    }\n");
print("}\n");
