#!/usr/common/bin/perl

package Special;
require Exporter;
require Carp;
@ISA = qw(Exporter);

# Use Opcodes to get function name list @fnames

use Opcodes qw(: @fnames);

if (!@fnames) {
    Carp::croak("Empty \@fnames!");
}

# Subroutine for setting a value in a class for all functions that match a
# regexp

sub regexp_set {
    my $class = $_[0];
    my $regexp = $_[1];
    my $value = $_[2];

    foreach $func (@fnames) {
	if ($func =~ /^$regexp$/) {
	    $$class{$func} = $value;
	}
    }
}

sub flush {
    if ($class) {
	regexp_set($class, $regexp, join("\n", @code)) if ($regexp);
	$$class = join("\n", @code) unless ($regexp);
    }
}

sub import {
    my $pkg = shift;
    my $file;
    while ($file = shift) {
	last if ($file eq ":");
	Carp::croak("Couldn't open file $file") if (!open(SPECIAL, $file));
	while (<SPECIAL>) {
	    $_ =~ s/\s*$//;
	    if (!$class) {
		$_ =~ s/^\s*//;
		next if (/^$/ || /^\#/);
	    }
	    if (/^\[\]$/) {
		flush();
		$class = 0;
	    }
	    elsif (/^\[(\S+)\s+(\S+)\]$/) {
		flush();
		$class = $1;
		$regexp = $2;
		@code = ();
		$classes{"\%$class"} = 1;
	    }
	    elsif (/^\[(\S+)\]$/) {
		flush();
		$class = $1;
		$regexp = 0;
		@code = ();
		$classes{"\$$class"} = 1;
	    }
	    elsif ($class) {
		push(@code, "$_");
	    }
	    else {
		Carp::croak("Parse error in file $file, line $.");
		exit(1);
	    }
	}
	close(SPECIAL);
    }
    flush();
    @EXPORT = ();
    foreach $class (keys(%classes)) {
	push(@EXPORT, $class);
    }
    if (@_) {
	$Exporter::ExportLevel = 1;
	Exporter::import($pkg, @_);
    }
}

1;
