#!/usr/common/bin/perl

package Opcodes;
require Exporter;
require Carp;
@ISA = qw(Exporter);
@EXPORT = qw(fntoop fntolb optofn optolb lbtofn lbtoop @fnames @lnames @ops);

# Function to convert a function name into a label name

sub mklabel {
    my $label;
    $label = $_[0];
    $label =~ s/^glt?//;
    $label =~ s/SGI$/Sgi/;
    $label =~ s/SGIS$/Sgis/;
    $label =~ s/SGIX$/Sgix/;
    $label =~ s/EXT$/Ext/;
    $label =~ s/([^0-9])([A-Z0-9])/$1_$2/g;
    $label =~ tr/a-z/A-Z/;
    return "GLT_OP_" . $label;
}

# Init internal arrays

@functions = ();
@opcodes = ();
@labels = ();
@labelops = ();

# Read opcode file

sub import {
    my $pkg = shift;
    my $file;
    while ($file = shift) {
	last if ($file eq ":");
	Carp::croak("Couldn't open file $file") if (!open(OPCODES, $file));
	while (<OPCODES>) {
	    next if (/^\#/);
	    next if (/^\s+$/);
	    if (/(\S+)\s+(\d+)(\S+)?/) {
		if (($3 && $3 ne "d") || $2 < 0) {
		    Carp::croak("Parse error in $file, line $.");
		}
		$label = &mklabel($1);
		$opcodes{$1} = $2;
		$functions{$2} = $1 unless ($3);
		$labels{$2} = $label unless ($3);
		$labelops{$label} = $2 unless ($3);
	    }
	}
    }
    if (@_) {
	$Exporter::ExportLevel = 1;
	Exporter::import($pkg, @_);
    }
    
    # Sort keys, store in exported arrays
    
    @fnames = sort(keys(%opcodes));
    @lnames = sort(keys(%labelops));
    @ops = sort {$a <=> $b} (keys(%labels));
}

# Exported functions for converting between functions, labels, and opcodes
    
sub fntoop {
    my $opcode = $opcodes{$_[0]};
    Carp::croak("fntoop: invalid function\n") if (!defined($opcode));
    return $opcode;
}

sub optofn {
    my $function = $functions{$_[0]};
    Carp::croak("optofn: invalid opcode\n") if (!defined($function));
    return $function;
}

sub optolb {
    my $label = $labels{$_[0]};
    Carp::croak("optolb: invalid opcode\n") if (!defined($label));
    return $label;
}

sub lbtoop {
    my $opcode = $labelops{$_[0]};
    Carp::croak("lbtoop: invalid label\n") if (!defined($opcode));
    return $opcode;
}

sub fntolb {
    my $opcode = $opcodes{$_[0]};
    Carp::croak("fntolb: invalid function\n") if (!defined($opcode));
    my $label = $labels{$opcode};
    Carp::croak("fntolb: invalid function\n") if (!defined($label));
    return $label;
}

sub lbtofn {
    my $opcode = $labelops{$_[0]};
    Carp::croak("lbtofn: invalid label\n") if (!defined($opcode));
    my $function = $functions{$opcode};
    Carp::croak("lbtofn: invalid label\n") if (!defined($function));
    return $function;
}

1;
