#!/usr/common/bin/perl

package Headers;
require Exporter;
require Carp;
@ISA = qw(Exporter);
@EXPORT = qw(fntype fnparms fnptypes fnpnames %typedefs %enums);

# Use Opcodes to get function name list @fnames

use Opcodes qw(: @fnames);

if (!@fnames) {
    Carp::croak("Empty \@fnames!");
}

# Build a hash of valid functions

foreach $func (@fnames) {
    $extract{$func} = 1;
}

# Initialize

%types = ();
%parms = ();
%ptypes = ();
%pnames = ();
%typedefs = ();

# Import function

sub import {
    my $pkg = shift;
    my $file;
    while ($file = shift) {
	last if ($file eq ":");
	if (!open(HEADER, $file)) {
	    Carp::croak("Couldn't open file $file");
	}
	while (<HEADER>) {
	    if (/typedef\s+(.*\s+(\*\s*)?)(\S+);\s*$/) {
		($typedefs{$3} = $1) =~ s/\s+$//;
	    }
	    if (/\#define\s+(\S+)\s+(0x\w\w\w\w)\s*$/) {
#		if (defined($enums{$2})) {
#		    Carp::croak("Duplicate enum $2 in $file!");
#		}
	        my $key = $1;
                my $val = $2;
		if ( $key !~/^GL_(POINTS|LINES|LINE_LOOP|LINE_STRIP|TRIANGLES|TRIANGLE_STRIP|TRIANGLE_FAN|QUADS|QUAD_STRIP|POLYGON)$/ ) {
		  $enums{hex($val)} = $key;
		}
	    }
	    elsif (/^extern\s+(.*)\s+(gl\S+)\s*\((.*)\);\s*$/) {
		$type = $1;
		$name = $2;
		$parms = $3;
		@ptypes = ();
		@pnames = ();
		foreach $parm (split(',', $parms)) {
		    if ($parm =~ /^\s*void\s*$/) {
			push(@ptypes, 'void');
		    }
		    elsif ($parm =~
			   /\s*((const)?\s*(.*\s+(\*\s*)?))(\S+)\s*$/) {
			$ptype = $1;
			$pname = $5;
			$ptype =~ s/\s+$//;
			$pname =~ s/\s+$//;
			push(@ptypes, $ptype);
			push(@pnames, $pname);
		    }
		    else {
			Carp::croak("Parse error in file $file, line $.!");
		    }
		}
		$ptypes = join(', ', @ptypes);
		$pnames = join(', ', @pnames);
		if ($extract{$name}) {
		    $types{$name} = $type;
		    $parms{$name} = $parms;
		    $ptypes{$name} = $ptypes;
		    $pnames{$name} = $pnames;
		}
	    }
	}
	close(HEADER);
    }
    $enums{0} = "GL_ZERO";
    $enums{1} = "GL_ONE";
    if (@_) {
	$Exporter::ExportLevel = 1;
	Exporter::import($pkg, @_);
    }
}

# Exported functions

sub fntype {
    my $type = $types{$_[0]};
    Carp::croak("fntype: invalid function") if (!defined($type));
    return $type;
}

sub fnparms {
    my $parms = $parms{$_[0]};
    Carp::croak("fntype: invalid function") if (!defined($parms));
    return $parms;
}

sub fnptypes {
    my $ptypes = $ptypes{$_[0]};
    Carp::croak("fntype: invalid function") if (!defined($ptypes));
    return $ptypes;
}

sub fnpnames {
    my $pnames = $pnames{$_[0]};
    Carp::croak("fntype: invalid function") if (!defined($pnames));
    return $pnames;
}

1;
