#!/usr/common/bin/perl

package Flags;
require Exporter;
require Carp;
@ISA = qw(Exporter);

# Use Opcodes to get function name list @fnames

use Opcodes qw(: @fnames);

if (!@fnames) {
    Carp::croak("Empty \@fnames!");
}

# Subroutine for setting a value in a class for all functions that match a
# regexp

sub regexp_set {
    my $class = $_[0];
    my $regexp = $_[1];
    my $value = $_[2];

    foreach $func (@fnames) {
	if ($func =~ /^$regexp$/) {
	    $$class{$func} = $value;
	}
    }
}

# Read Flags file

sub import {
    my $pkg = shift;
    my $file;
    while ($file = shift) {
	last if ($file eq ":");
	Carp::croak("Couldn't open file $file") if (!open(FLAGS, $file));
	while (<FLAGS>) {
	    $_ =~ s/^\s*//;
	    $_ =~ s/\s*$//;
	    next if (/^$/ || /^\#/);
	    if (/^\[(\S+)\]$/) {
		$class = $1;
		$classes{$class} = 1;
	    }
	    elsif (/^(\S+)(\s+(\S+))?$/) {
		regexp_set($class, $1, $3) if ($3);
		regexp_set($class, $1, 1) unless ($3);
	    }
	    else {
		Carp::croak("Parse error in file $file, line $.");
	    }
	}
	close(FLAGS);
    }
    @EXPORT = ();
    foreach $class (keys(%classes)) {
	push(@EXPORT, "\%$class");
    }
    if (@_) {
	$Exporter::ExportLevel = 1;
	Exporter::import($pkg, @_);
    }
}

1;
