#!/usr/common/bin/perl

package Encode;
require Exporter;
require Carp;
@ISA = qw(Exporter);
@EXPORT = qw(fnpstypes fnpisvecs fnpveclens fnpoffsets fnssize
             fnsalign fnspad fnsname);

# Use Opcodes to get function name list @fnames
# Use Flags to get %lengths, %structalign, %maxvoidsize
# Use Headers to get %typedefs

use Opcodes qw(: @fnames);
use Flags qw(: %lengths %structalign %maxvoidsize);
use Headers qw(: fntype fnptypes %typedefs);

Carp::croak("Empty \@fnames!") if (!@fnames);
Carp::croak("Empty \%lengths!") if (!keys(%lengths));
Carp::croak("Empty \%structalign!") if (!keys(%structalign));
Carp::croak("Empty \%maxvoidsize!") if (!keys(%maxvoidsize));
Carp::croak("Empty \%typedefs!") if (!keys(%typedefs));

# Subroutine for computing the size of a variable

sub sizeof {
    my $type = $_[0];
    $type = $typedefs{$type} if (defined($typedefs{$type}));
    return 1 if ($type =~ /char/);
    return 2 if ($type =~ /short/);
    return 4 if ($type =~ /int/);
    return 4 if ($type =~ /float/);
    return 8 if ($type =~ /double/);
    return 4 if ($type =~ /\*/);
    return 0 if ($type =~ /void/);
    Carp::croak("Couldn't determine sizeof($type) for $_[1]");
}

# Subroutine for computing pad to align $_[0] to a $_[1] boundary

sub align {
    return ($_[1] <= 0) ? 0 : -$_[0] & ($_[1] - 1);
}

# Subroutine for computing struct name

sub sname {
    my $name = $_[0];
    $name =~ s/^glt?//;
    $name =~ s/SGI$/Sgi/;
    $name =~ s/SGIS$/Sgis/;
    $name =~ s/SGIX$/Sgix/;
    $name =~ s/EXT$/Ext/;
    $name =~ s/([^0-9])([A-Z0-9])/$1_$2/g;
    $name =~ tr/A-Z/a-z/;
    return "GLT_$name";
}

# Initialize

%pstypes = ();
%pisvecs = ();
%pveclens = ();
%poffsets = ();
%ssizes = ();
%saligns = ();
%spads = ();
%snames = ();

foreach $name (@fnames) {
    $type = fntype($name);
    @ptypes = split(', ', fnptypes($name));
    @pstypes = ();
    @pisvecs = ();
    @pveclens = ();
    @poffsets = ();
    $ssize = 0;
    $salign = $structalign{$name};
    $maxvoidsize = $maxvoidsize{$name};
    $sname = sname($name);
    foreach $ptype (@ptypes) {
	if ($ptype eq 'void') {
	    push(@pstypes, 'void');
	    push(@isvecs, 0);
	    push(@pveclens, 0);
	    push(@poffsets, 0);
	}
	else {
	    $ptype =~ s/^const\s+//;
	    $pisvec = ($ptype =~ /\*$/);
	    $pveclen = ($pisvec) ? $lengths{$name} : 0;
	    $ptype =~ s/\s+\*$//;
	    $pstype = $ptype;
	    $pstype =~ s/^GL/GLT/ if ($pstype !~ /^GLT/);
	    $psize = sizeof($ptype);
	    $psize = sizeof("\*") if ($pisvec && !$pveclen);
	    if ($pisvec) {
		if ($pveclen) {
		    $psize = sizeof($ptype);
		    $ssize += align($ssize, $psize);
		    $poffset = $ssize;
		    $ssize += $psize * $pveclen;
		}
		else {
		    $psize = $intsize = sizeof("int");
		    $ssize += align($ssize, $psize);
		    $poffset = $ssize;
		    $ssize += $psize;
		    $psize = $starsize = sizeof("\*");
		    $ssize += align($ssize, $psize) + $psize;
		    $psize = sizeof($ptype);
		    $psize = $maxvoidsize unless ($psize);
		    $psize = $intsize if ($psize < $intsize);
		    $psize = $starsize if ($psize < $starsize);
		}
	    } else {
		$psize = sizeof($ptype);
		$ssize += align($ssize, $psize);
		$poffset = $ssize;
		$ssize += $psize;
	    }
	    $salign = $psize if ($psize > $salign);
	    push(@pstypes, $pstype);
	    push(@pisvecs, $pisvec);
	    push(@pveclens, $pveclen);
	    push(@poffsets, $poffset);
	}
    }
    $pstypes  = join(':', @pstypes);
    $pisvecs  = join(':', @pisvecs);
    $pveclens = join(':', @pveclens);
    $poffsets = join(':', @poffsets);
    $spad = align($ssize, $structalign{$name});
    $ssize += $spad;
    $pstypes{$name} = $pstypes;
    $pisvecs{$name} = $pisvecs;
    $pveclens{$name} = $pveclens;
    $poffsets{$name} = $poffsets;
    $ssizes{$name} = $ssize;
    $saligns{$name} = $salign;
    $spads{$name} = $spad;
    $snames{$name} = $sname;
}

# Exported functions

sub fnpstypes {
    my $pstypes = $pstypes{$_[0]};
    Carp::croak("fnpstypes: invalid function") if (!defined($pstypes));
    return $pstypes;
}

sub fnpisvecs {
    my $pisvecs = $pisvecs{$_[0]};
    Carp::croak("fnpisvecs: invalid function") if (!defined($pisvecs));
    return $pisvecs;
}

sub fnpveclens {
    my $pveclens = $pveclens{$_[0]};
    Carp::croak("fnpveclens: invalid function") if (!defined($pveclens));
    return $pveclens;
}

sub fnpoffsets {
    my $poffsets = $poffsets{$_[0]};
    Carp::croak("fnpoffsets: invalid function") if (!defined($poffsets));
    return $poffsets;
}

sub fnssize {
    my $ssize = $ssizes{$_[0]};
    Carp::croak("fnssize: invalid function") if (!defined($ssize));
    return $ssize;
}

sub fnsalign {
    my $salign = $saligns{$_[0]};
    Carp::croak("fnsalign: invalid function") if (!defined($salign));
    return $salign;
}

sub fnspad {
    my $spad = $spads{$_[0]};
    Carp::croak("fnspad: invalid function") if (!defined($spad));
    return $spad;
}

sub fnsname {
    my $sname = $snames{$_[0]};
    Carp::croak("fnsname: invalid function") if (!defined($sname));
    return $sname;
}

1;
