#!/usr/common/bin/perl
#
# optab.c.pl
#
# Kekoa Proudfoot 3/31/98
#

use lib "../perl/modules";

use Includes;

use Opcodes qw(: @ops optofn fntolb fntoop);
use Flags   qw(: %ignore %noencode);
use Headers qw();
use Encode  qw(fnpstypes fnpisvecs fnpveclens fnpoffsets fnssize fnsalign);

@valid = ();
foreach $op (@ops) {
    $name = optofn($op);
    next if ($ignore{$name} || $noencode{$name});
    $valid[$op] = $name;
}

foreach $name (@valid) {
    if (defined($name)) {
	@pstypes = split(':', fnpstypes($name));
	@pisvecs = split(':', fnpisvecs($name));
	@pveclens = split(':', fnpveclens($name));

	next if ($pstypes[0] eq 'void');

	$hasvecs = 0;
	while (@pstypes) {
	    $pstype = shift(@pstypes);
	    $pisvec = shift(@pisvecs);
	    $pveclen = shift(@pveclens);
	    $hasvecs = 1 if ($pisvec && !$pveclen);
	}
	print("$name\n") if ($hasvecs);
    }
}


