#
# shared Makefile
#
# Kekoa Proudfoot
# 6/17/98
#

# architecture

UNAME=$(shell uname)
ARCH=WIN32
ifeq ($(UNAME),IRIX)
  ARCH=IRIX
endif
ifeq ($(UNAME),IRIX64)
  ARCH=IRIX
endif
ifeq ($(UNAME),Linux)
  ARCH=LINUX
endif

# programs

ifeq ($(ARCH),IRIX)
CC = cc
AR = ar rc
PL = /usr/common/bin/perl
SO = cc -shared -all
LD = cc
endif

ifeq ($(ARCH),LINUX)
CC = gcc
AR = ar rc
PL = /usr/bin/perl
SO = gcc -shared -all
LD = gcc
endif

ifeq ($(ARCH),WIN32)
CC = cl -nologo
AR = lib -nologo
SO = link -nologo -entry:_DllMainCRTStartup@12 -dll
LD = link -nologo
endif

# special targets

.PHONY: all depend clean noperl nolinks nodepend veryclean veryveryclean

ifeq ($(ARCH),IRIX)
.PRECIOUS: %.o %.c %.h
endif

ifeq ($(ARCH),WIN32)
.PRECIOUS: %.o
endif

# pattern rules

__ALL_INCS = $(strip $(INCS) $(INCS_$*))
__ALL_LIBS = $(strip $(LIBS) $(LIBS_$*))
__ALL_CFLAGS = $(strip $(CFLAGS) $(CFLAGS_$*))
__ALL_LFLAGS = $(strip $(LFLAGS) $(LFLAGS_$*))

ifneq ($(ARCH),WIN32)
%: %.c
%: %.o
%.o: %.c
	$(CC) $(__ALL_CFLAGS) $(__ALL_INCS) -c $*.c
%.o: %.cc
	$(CC) $(__ALL_CFLAGS) $(__ALL_INCS) -c $*.cc
%.c: %.c.pl
	$(PL) $*.c.pl > $*.c || (rm -f $*.c ; false)
%.h: %.h.pl
	$(PL) $*.h.pl > $*.h || (rm -f $*.h ; false)
%.a:
	rm -f $*.a
	$(AR) $*.a $^
%.so:
	$(SO) $(__ALL_LFLAGS) -o $*.so $(filter %.o,$^) $(__ALL_LIBS)
%: %.o
	$(LD) $(__ALL_LFLAGS) -o $* $(filter %.o,$^) $(__ALL_LIBS)
endif

ifeq ($(ARCH),WIN32)
%.o: %.c
	$(CC) $(__ALL_CFLAGS) $(__ALL_INCS) -c $*.c -Fo$*.o
%.o: %.cc
	$(CC) $(__ALL_CFLAGS) -TP $(__ALL_INCS) -c $*.cc -Fo$*.o
%.lib:
	$(AR) $(__ALL_LFLAGS) -out:$*.lib $^
%.dll:
	$(SO) $(__ALL_LFLAGS) -out:$*.dll $(filter %.o,$^) $(__ALL_LIBS)
%.exe: %.o
	$(LD) $(__ALL_LFLAGS) $(filter %.o,$^) $(__ALL_LIBS)
endif

# includes

-include $(ROOT)/make/config.mk  # do not modify this file
-include $(ROOT)/Config          # override config.mk here
