/*
 *  swap.h
 *
 *  Header file for the machine generated endian swap routines
 *  Note that swapping and unswapping use the same functions
 *
 *  Kekoa Proudfoot
 *  6/14/98
 */

#ifndef SWAP_H_DEFINED
#define SWAP_H_DEFINED

#include "glt.h"

/* Swap primitives */

extern short __glt_swap_short(short s);
extern int __glt_swap_long(int i);
extern float __glt_swap_float(float f);
extern double __glt_swap_double(double d);

extern void __glt_swap_shortv(int n, short *vec);
extern void __glt_swap_longv(int n, int *vec);
extern void __glt_swap_floatv(int n, float *vec);
extern void __glt_swap_doublev(int n, double *vec);

/* Swap routines */

extern void __glt_swap_header(GLT_dheader *header);
extern void __glt_swap_data(GLT_opcode op, GLT_data *data);
extern void __glt_swap_vectors(GLT_opcode op, GLT_data *data);

#define __glt_unswap_header(header) __glt_swap_header(header)
#define __glt_unswap_data(op,data) __glt_swap_data(op,data)
#define __glt_unswap_vectors(op,data) __glt_swap_vectors(op,data)

#endif /* SWAP_H_DEFINED */
