#!/usr/common/bin/perl
#
# swap.c.pl
#
# Kekoa Proudfoot 6/14/98
#

use lib "../perl/modules";

use Includes;

use Special qw(swap.c.sp);

use Opcodes qw(: @ops optofn fntolb);
use Flags   qw(: %ignore %noencode);
use Special qw(: %swapvecs);
use Encode  qw(fnssize fnsname);

# Enumerate valid functions

@valid = ();
foreach $op (@ops) {
    $name = optofn($op);
    next if ($ignore{$name} || $noencode{$name});
    push(@valid, $name);
}

# Generate code

print("/*\n");
print(" * swap.c\n");
print(" *\n");
print(" * Machine generated swap routines\n");
print(" *\n");
print(" */\n");
print("\n");

print("/* Include files */\n");
print("\n");

print("#include <assert.h>\n");
print("\n");

print("#ifdef WIN32\n");
print("#define WIN32_LEAN_AND_MEAN\n");
print("#include <windows.h>\n");
print("#endif\n");
print("#include <GL/gl.h>\n");
print("\n");

print("#include \"glt.h\"\n");
print("#include \"swap.h\"\n");
print("#include \"optab.h\"\n");
print("\n");

print("/* Macros */\n");
print("\n");

print("#define align(p,type) (-(int)(p)&(sizeof(type)-1))\n");
print("\n");

print("/* Inline functions */\n");
print("\n");

print("static __inline short\n");
print("swap_short(short s)\n");
print("{\n");
print("    unsigned char b0, b1;\n");
print("    b0 = (s>>0) & 0xff;\n");
print("    b1 = (s>>8) & 0xff;\n");
print("    return (b0<<8) + b1;\n");
print("}\n");
print("\n");

print("static __inline int\n");
print("swap_long(int i)\n");
print("{\n");
print("    unsigned char b0, b1, b2, b3;\n");
print("    b0 = (i>>0)  & 0xff;\n");
print("    b1 = (i>>8)  & 0xff;\n");
print("    b2 = (i>>16) & 0xff;\n");
print("    b3 = (i>>24) & 0xff;\n");
print("    return (int)(b0<<24) + (int)(b1<<16) + (int)(b2<<8) + b3;\n");
print("}\n");
print("\n");

print("static __inline float\n");
print("swap_float(float f)\n");
print("{\n");
print("    union { unsigned char b[4]; float f; } in, out;\n");
print("    in.f = f;\n");
print("    out.b[0] = in.b[3];\n");
print("    out.b[1] = in.b[2];\n");
print("    out.b[2] = in.b[1];\n");
print("    out.b[3] = in.b[0];\n");
print("    return out.f;\n");
print("}\n");
print("\n");

print("static __inline double\n");
print("swap_double(double d)\n");
print("{\n");
print("    union { unsigned char b[8]; double d; } in, out;\n");
print("    in.d = d;\n");
print("    out.b[0] = in.b[7];\n");
print("    out.b[1] = in.b[6];\n");
print("    out.b[2] = in.b[5];\n");
print("    out.b[3] = in.b[4];\n");
print("    out.b[4] = in.b[3];\n");
print("    out.b[5] = in.b[2];\n");
print("    out.b[6] = in.b[1];\n");
print("    out.b[7] = in.b[0];\n");
print("    return out.d;\n");
print("}\n");
print("\n");

print("static __inline void\n");
print("swap_shortv(unsigned int n, short *vec)\n");
print("{\n");
print("    unsigned int i;\n");
print("    for ( i = 0; i < n; i++ )\n");
print("        vec[i] = swap_short(vec[i]);\n");
print("}\n");
print("\n");

print("static __inline void\n");
print("swap_longv(unsigned int n, int *vec)\n");
print("{\n");
print("    unsigned int i;\n");
print("    for ( i = 0; i < n; i++ )\n");
print("        vec[i] = swap_long(vec[i]);\n");
print("}\n");
print("\n");

print("static __inline void\n");
print("swap_floatv(unsigned int n, float *vec)\n");
print("{\n");
print("    unsigned int i;\n");
print("    for ( i = 0; i < n; i++ )\n");
print("        vec[i] = swap_float(vec[i]);\n");
print("}\n");
print("\n");

print("static __inline void\n");
print("swap_doublev(unsigned int n, double *vec)\n");
print("{\n");
print("    unsigned int i;\n");
print("    for ( i = 0; i < n; i++ )\n");
print("        vec[i] = swap_double(vec[i]);\n");
print("}\n");
print("\n");

print("/* Swap primitives */\n");
print("\n");

print("short\n");
print("__glt_swap_short(short s)\n");
print("{\n");
print("    return swap_short(s);\n");
print("}\n");
print("\n");

print("void\n");
print("__glt_swap_shortv(int n, short *vec)\n");
print("{\n");
print("    swap_shortv(n,vec);\n");
print("}\n");
print("\n");

print("int\n");
print("__glt_swap_long(int i)\n");
print("{\n");
print("    return swap_long(i);\n");
print("}\n");
print("\n");

print("void\n");
print("__glt_swap_longv(int n, int *vec)\n");
print("{\n");
print("    swap_longv(n,vec);\n");
print("}\n");
print("\n");

print("float\n");
print("__glt_swap_float(float f)\n");
print("{\n");
print("    return swap_float(f);\n");
print("}\n");
print("\n");

print("void\n");
print("__glt_swap_floattv(int n, float *vec)\n");
print("{\n");
print("    swap_floatv(n,vec);\n");
print("}\n");
print("\n");

print("double\n");
print("__glt_swap_double(double d)\n");
print("{\n");
print("    return swap_double(d);\n");
print("}\n");
print("\n");

print("void\n");
print("__glt_swap_doublev(int n, double *vec)\n");
print("{\n");
print("    swap_doublev(n,vec);\n");
print("}\n");
print("\n");

print("/* Swap routines */\n");
print("\n");

print("void\n");
print("__glt_swap_header(GLT_dheader *header)\n");
print("{\n");
print("    header->op = swap_short(header->op);\n");
print("    header->len = swap_short(header->len);\n");
print("    header->llen = swap_long(header->llen);\n");
print("}\n");
print("\n");

print("void\n");
print("__glt_swap_data(GLT_opcode op, GLT_data *data)\n");
print("{\n");
print("    char *format;\n");
print("    char *datap = (char *)data;\n");
print("    int offset = 0;\n");
print("    if (op > GLT_NUM_OPS)\n");
print("        op = GLT_OP_BAD;\n");
print("    for (format = ot_getstrent(op)->format; format[0]; format++) {\n");
print("        switch (format[0]) {\n");
print("        case OT_BOOLEAN:\n");
print("        case OT_BYTE:\n");
print("        case OT_UBYTE:\n");
print("        case OT_ASTART:\n");
print("        case OT_AFINISH:\n");
print("            break;\n");
print("        case OT_SHORT:\n");
print("        case OT_USHORT:\n");
print("            offset += align(offset, short);\n");
print("            *(short *)&datap[offset] = swap_short(*(short *)&datap[offset]);\n");
print("            offset += sizeof(short);\n");
print("            break;\n");
print("        case OT_BITFIELD:\n");
print("        case OT_ENUM:\n");
print("        case OT_INT:\n");
print("        case OT_UINT:\n");
print("            offset += align(offset, int);\n");
print("            *(int *)&datap[offset] = swap_long(*(int *)&datap[offset]);\n");
print("            offset += sizeof(int);\n");
print("            break;\n");
print("        case OT_FLOAT:\n");
print("            offset += align(offset, float);\n");
print("            *(float *)&datap[offset] = swap_float(*(float *)&datap[offset]);\n");
print("            offset += sizeof(float);\n");
print("            break;\n");
print("        case OT_DOUBLE:\n");
print("            offset += align(offset, double);\n");
print("            *(double *)&datap[offset] = swap_double(*(double *)&datap[offset]);\n");
print("            offset += sizeof(double);\n");
print("            break;\n");
print("        case OT_VOIDP:\n");
print("            offset += align(offset, int);\n");
print("            *(int *)&datap[offset] = swap_long(*(int *)&datap[offset]);\n");
print("            offset += sizeof(int);\n");
print("            offset += sizeof(int);\n");
print("            break;\n");
print("        default:\n");
print("            assert(format[0] != format[0]);\n");
print("            break;\n");
print("        }\n");
print("    }\n");
print("}\n");
print("\n");

print("void\n");
print("__glt_swap_vectors(GLT_opcode op, GLT_data *data)\n");
print("{\n");
print("    switch (op) {\n");

foreach $name (@valid) {
    if ($swapvecs{$name}) {
	$label = fntolb($name);
	$ssize = fnssize($name);
	Carp::croak("Uh-oh, swapvecs but not struct for $name!") if (!$ssize);
        $sname = fnsname($name);
        ($uname = $sname) =~ s/^GLT_//;
	print("        case $label:\n");
	print("        {\n");
        print("            $sname *d = &data->$uname;\n");
	print("$swapvecs{$name}\n");
	print("            break;\n");
	print("        }\n");
    }
}
print("    }\n");
print("}\n");
print("\n");
