/*
 *  optab.h
 *
 *  Header file for the machine generated opcode table
 *
 *  Kekoa Proudfoot
 *  4/30/98
 */

#ifndef OPTAB_H_DEFINED
#define OPTAB_H_DEFINED

#include "glt.h"

/* Opcode table flags */

#define OT_NONE      0x00             /* no flags */
#define OT_DALIGN    0x01             /* use double alignment */
#define OT_HASV      0x02             /* has vectors, use extended header */
#define OT_BAD       0x04             /* invalid opcode */

/* Opcode table offset list terminator */

#define OT_LAST      0xff

/* Opcode table struct */

#define OT_MAXOFS    2                /* should equal GLT_MAXV */

typedef struct {
    unsigned char flags;              /* flags */
    unsigned char len;                /* struct length */
    unsigned char offsets[OT_MAXOFS]; /* vector offsets (in ints) */
} GLT_op_tab_ent;

/* Opcode table format string chars */

#define OT_BITFIELD  'x'
#define OT_BOOLEAN   'o'
#define OT_BYTE      'b'
#define OT_DOUBLE    'd'
#define OT_ENUM      'e'
#define OT_FLOAT     'f'
#define OT_INT       'i'
#define OT_SHORT     's'
#define OT_UBYTE     'B'
#define OT_UINT      'I'
#define OT_USHORT    'S'
#define OT_VOIDP     'v'
#define OT_ASTART    '{'
#define OT_AFINISH   '}'

/* Opcode table string struct - separate to make GLT_op_tab_ent small */

typedef struct {
    char *opname;                     /* opcode name */
    char *funcname;                   /* function name */
    char *format;                     /* format string */
} GLT_op_tab_str_ent;

extern GLT_op_tab_ent __glt_op_tab_ents[];
extern GLT_op_tab_str_ent __glt_op_tab_str_ents[];

#define ot_getent(op)     (&__glt_op_tab_ents[op])
#define ot_getstrent(op)  (&__glt_op_tab_str_ents[op])

#endif /* OPTAB_H_DEFINED */
