#!/usr/common/bin/perl
#
# glt.h.pl
#
# Kekoa Proudfoot 3/31/98, 4/98, 5/98
#

# Configuration variables

$GLT_VERSION = 1; # current version
$GLT_COMPAT  = 1; # minimum version for compatibility

# Everything else follows

use lib "../perl/modules";

use Includes;

use Opcodes qw(: @ops optofn fntolb fntoop);
use Flags   qw(: %ignore %noencode);
use Headers qw(: fntype fnpnames %typedefs);
use Encode  qw(fnpstypes fnpisvecs fnpveclens fnssize fnspad fnsname);

$lastop = 0;
foreach $op (@ops) {
    $name = optofn($op);
    next if ($ignore{$name} || $noencode{$name});
    push(@names, $name);
    $lastop = $op if ($op > $lastop);
}
$numops = $lastop + 1;

print("/*\n");
print(" * glt.h\n");
print(" *\n");
print(" * Machine generated glt header file\n");
print(" *\n");
print(" */\n");
print("\n");

print("#ifndef GLT_H_DEFINED\n");
print("#define GLT_H_DEFINED\n");
print("\n");

print("#if _SIZE_PTR == 64\n");
print("#define GLT64 1\n");
print("#endif\n");
print("\n");

print("/* GLT types */\n");
print("\n");

foreach $type (sort(keys(%typedefs))) {
    ($typename = $type) =~ s/^GL/GLT/;
    print("typedef $typedefs{$type} $typename;\n");
}
print("\n");

print("/* Enum of all opcodes */\n");
print("\n");
print("enum {\n");

foreach $name (@names) {
    $label = fntolb($name);
    $opcode = fntoop($name);
    printf("    %-30s = $opcode,\n", $label);
}
printf("    %-30s = $numops\n", "GLT_NUM_OPS");

print("};\n");
print("\n");


print("/* Structs for encoding functions */\n");
print("\n");

print("typedef struct {\n");
print("    GLTushort op;\n");
print("    GLTushort len;\n");
print("    GLTuint   llen;\n");
print("} GLT_dheader;\n");
print("\n");

foreach $name (@names) {
    $type = fntype($name);
    @pnames = split(', ', fnpnames($name));
    @pstypes = split(':', fnpstypes($name));
    @pisvecs = split(':', fnpisvecs($name));
    @pveclens = split(':', fnpveclens($name));

    $need64 = 0;
    for ( my $i = 0; $i < @pisvecs; $i++ ) {
      $need64++ if ( $pisvecs[$i] && !$pveclens[$i] );
    }

    $ssize = fnssize($name);
    $spad = fnspad($name);
    $sname = fnsname($name);
    next if ($ssize == 0);

    print("typedef struct {\n");

    # Ack! return values not handled correctly
    # Need to fix alignments, offsets, return type, etc. in Encode.pm
    if ($type ne 'void') {
        Carp::croak("Return values not handled correctly! ($name)");
    }

    print("#ifndef GLT64\n") if ($need64);

    while (@pstypes) {
        $pname = shift(@pnames);
        $pstype = shift(@pstypes);
        $pisvec = shift(@pisvecs); 
        $pveclen = shift(@pveclens);
        if ($pisvec) {
            print("    $pstype ${pname}[$pveclen];\n") if ($pveclen);
            print("    GLTuint n_${pname};\n") if (!$pveclen);
            print("    $pstype *$pname;\n") if (!$pveclen);
        }
        else {
            print("    $pstype $pname;\n");
        }
    }
    print("    GLTubyte pad[$spad];\n") if ($spad);

    if ($need64) {
      print("#else\n");

      @pnames = split(', ', fnpnames($name));
      @pstypes = split(':', fnpstypes($name));
      @pisvecs = split(':', fnpisvecs($name));
      @pveclens = split(':', fnpveclens($name));

      my @ptrs;
      while (@pstypes) {
        $pname = shift(@pnames);
        $pstype = shift(@pstypes);
        $pisvec = shift(@pisvecs); 
        $pveclen = shift(@pveclens);
        if ($pisvec) {
          print("    $pstype ${pname}[$pveclen];\n") if ($pveclen);
          print("    GLTuint n_${pname};\n") if (!$pveclen);
          print("    GLTuint pad_${pname};\n") if (!$pveclen);
          push(@ptrs, "    $pstype *$pname;\n") if (!$pveclen);
        }
        else {
            print("    $pstype $pname;\n");
        }
      }
      print("    GLTubyte pad[$spad];\n") if ($spad);
      
      print join('',@ptrs) if (@ptrs);
      print("#endif\n");
    }
    print("} $sname;\n");
    print("\n");
}

print("/* Union of all encoding structs */\n");
print("\n");

print("typedef union {\n");

foreach $name (@names) {
    next if (fnssize($name) == 0);
    $sname = fnsname($name);
    ($uname = $sname) =~ s/^GLT_//;
    printf("    %-30s $uname;\n", $sname);
}
print("} GLT_data;\n");
print("\n");


print("/* Hack! */\n");
print("#include <stdio.h>\n");
print("\n");

print("/* Trace version */\n");
print("#define GLT_MAGIC    (('G'<<24)|('L'<<16)|('T'<<8)|('0'<<0))\n");
print("#define GLT_SMAGIC   (('0'<<24)|('T'<<16)|('L'<<8)|('G'<<0))\n");
print("#define GLT_GZMAGIC  (0x1f8b0808)\n");
print("#define GLT_VERSION  $GLT_VERSION\n");
print("#define GLT_COMPAT   $GLT_COMPAT\n"); # minimum compatible version
print("\n");

print("/* Hack? External flags */\n");
print("#define GLT_RDONLY   0x0000\n");
print("#define GLT_WRONLY   0x0001\n");
#print("#define GLT_RDWR     0x0002\n"); # not implemented 
print("#define GLT_FILE     0x0000\n");
print("#define GLT_MEM      0x0004\n");
print("#define GLT_UNWIND   0x0008\n");
print("#define GLT_RETLIST  0x0010\n");
print("#define GLT_ERROK    0x0020\n"); # don't check header during open
print("/* Hack? */\n");
print("#define GLT_WSWAP    0x0040\n"); # swap when writing
print("#define GLT_UNBUF    0x0080\n"); # turn off file buffering
print("#define GLT_BUFFER   0x0000\n"); # turn on file buffering
print("\n");

print("/* Hack? Internal flags */\n");
print("#define GLT_RDOK     0x0100\n");     
print("#define GLT_WROK     0x0200\n");
print("#define GLT_NFILE    0x0400\n");
print("#define GLT_NSEEK    0x0800\n");
print("#define GLT_EOF      0x1000\n");
print("#define GLT_ERR      0x2000\n");
print("#define GLT_RSWAP    0x4000\n");
print("#define GLT_GZIP     0x8000\n");
print("\n");

print("/* Hack? Debug mode bits for glt_mesg and glt_mesg_va */\n");
print("#define GLT_WARN     0x0001  /* maskable warning */\n");
print("#define GLT_EWARN    0x0002  /* encoder warning */\n");
print("#define GLT_ENV      0x0004  /* environment settings */\n");
print("#define GLT_PUT      0x0008  /* put */\n");
print("#define GLT_PUTF     0x0010  /* put functions */\n");
print("#define GLT_CWARN    0x0020  /* call gl warnings */\n");
print("#define GLT_PSTORE   0x0040  /* pixel store functions */\n");
print("#define GLT_MALLOC   0x0080  /* debug memory allocation */\n");
print("#define GLT_DEBUG    0x8000  /* temporary debug message */\n");
print("\n");

print("/* Trace struct */\n");
print("\n");

print("#define GLT_MAXV       2       /* should equal OT_MAXOFS */\n");
print("\n");

print("/* Hack! */\n");
print("typedef GLTushort GLT_opcode;\n");
print("\n");

print("/* Hack! */\n");
print("typedef struct GLT_trace {\n");
print("    FILE *file;\n");
print("    int flags;\n");
print("    int pos;\n");
print("    int len;\n");
print("    void *data;\n");
print("    GLT_dheader header;\n");
print("    int nallocvecs;\n");
print("    void *allocvecs[GLT_MAXV];\n");
print("    int ngetvecs;\n");
print("    void *getvecs[GLT_MAXV];\n");
print("    void (*close)(struct GLT_trace *);\n");
print("    void *(*allocv)(struct GLT_trace *, int);\n");
print("    void (*put)(struct GLT_trace *, GLT_opcode, GLT_data *);\n");
print("    GLT_opcode (*peek)(struct GLT_trace *);\n");
print("    GLT_opcode (*get)(struct GLT_trace *, GLT_data *);\n");
print("    void (*skip)(struct GLT_trace *);\n");
print("    int (*tell)(struct GLT_trace *);\n");
print("    void (*seek)(struct GLT_trace *, int pos);\n");
print("    int (*eof)(struct GLT_trace *);\n");
print("    int (*err)(struct GLT_trace *);\n");
print("    GLTint magic;\n");
print("    GLTint version;\n");
print("    struct GLT_dlist_state *dlist;\n");
print("} GLT_trace;\n");
print("\n");

print("/* Hack! */\n");
print("extern FILE *__glt_errfile;\n");
print("extern int __glt_debug;\n");
print("extern int __glt_text_enums;\n");
print("\n");

print("/* Open function */\n");
print("extern void glt_open(GLT_trace *trace, char *filename, int flags);\n");
print("\n");

print("/* Function pointer macros */\n");
print("#define glt_close(trace)        ((trace)->close(trace))\n");
print("#define glt_allocv(trace,size)  ((trace)->allocv(trace,size))\n");
print("#define glt_put(trace,op,data)  ((trace)->put(trace,op,data))\n");
print("#define glt_peek(trace)         ((trace)->peek(trace))\n");
print("#define glt_get(trace,data)     ((trace)->get(trace,data))\n");
print("#define glt_skip(trace)         ((trace)->skip(trace))\n");
print("#define glt_tell(trace)         ((trace)->tell(trace))\n");
print("#define glt_seek(trace,pos)     ((trace)->seek(trace,pos))\n");
print("#define glt_eof(trace)          ((trace)->eof(trace))\n");
print("#define glt_err(trace)          ((trace)->err(trace))\n");
print("\n");

print("/* Text functions */\n");
print("extern char *glt_label(GLT_opcode op);\n");
print("extern char *glt_name(GLT_opcode op);\n");
print("extern char *glt_text(GLT_opcode op, GLT_data *data);\n");
print("\n");

print("/* Render function */\n");
print("extern void glt_callgl(GLT_opcode op, GLT_data *data);\n");
print("\n");

print("/* Window playback */\n");
print("extern void glt_set_window_name_pattern( const char *pattern );\n");
print("\n");

print("/* Memory allocation functions */\n");
print("#ifndef NDEBUG\n");
print("extern void *__glt_malloc(int size, const char *file, int line);\n");
print("extern void *__glt_realloc(void *ptr, int size, const char *file, int line);\n");
print("extern void __glt_free(void *ptr, const char *file, int line);\n");
print("/* Hack? */\n");
print("extern void __glt_printmem(void);\n");
print("#define glt_malloc(size) __glt_malloc(size,__FILE__,__LINE__)\n");
print("#define glt_realloc(ptr,size) __glt_realloc(ptr,size,__FILE__,__LINE__)\n");
print("#define glt_free(ptr) __glt_free(ptr,__FILE__,__LINE__)\n");
print("#else\n");
print("extern void *__glt_malloc(int size);\n");
print("extern void *__glt_realloc(void *ptr, int size);\n");
print("#define glt_malloc(size) __glt_malloc(size)\n");
print("#define glt_realloc(ptr,size) __glt_realloc(ptr,size)\n");
print("#define glt_free(ptr) free(ptr)\n");
print("#define __glt_printmem()\n");
print("#endif\n");
print("\n");

print("/* Error functions */\n");
print("extern void glt_warn(char *fmt, ...);\n");
print("extern void glt_fatal(char *fmt, ...);\n");
print("\n");

print("/* If macros */\n");
print("#define __glt_if(c,t)     do { if (c) t; } while (0)\n");
print("#define __glt_ife(c,t,e)  do { if (c) t; else e; } while (0)\n");
print("\n");

print("/* Debug functions */\n");
print("#ifndef NDEBUG\n");
print("#define glt_mesg(f,m)     __glt_if(__glt_debug & (f),glt_warn(m))\n");
print("#define glt_mesg_va(f,p)  __glt_if(__glt_debug & (f),glt_warn##p)\n");
print("#else\n");
print("#define glt_mesg(f,m)\n");
print("#define glt_mesg_va(f,p)\n");
print("#endif\n");
print("\n");

print("#endif /* GLT_H_DEFINED */\n");

# print("main() {\n");

# foreach $name (@names) {
#     $ssize = fnssize($name);
#     $sname = fnsname($name);
#     next if (!$ssize);
# #     print("    if (sizeof($sname) != $ssize)\n");
#     print("        printf(\"sizeof($sname) = %d ($ssize)\\n\", " .
# 	  "sizeof($sname));\n");
# }

# print("}\n");
