/*
 *  errors.c
 *
 *  Error handling code for glt library
 *
 *  Kekoa Proudfoot
 *  5/11/98, 5/20/98
 */

/* Include files */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "glt.h"

/* Configuration macros */

#ifndef NDEBUG
#define DEFAULT_DEBUG_MODE (GLT_WARN | GLT_EWARN | GLT_MALLOC)
#else
#define DEFAULT_DEBUG_MODE 0
#endif

/* Global variables */

/* On Linux 'stderr' isn't a static initializer (?), so get around
   things in this clunky way to get the default behavior we want */
static int __glt_errfile_init = 0;
FILE *__glt_errfile = NULL;
int __glt_debug = DEFAULT_DEBUG_MODE;

/* Functions */

void
glt_warn(char *fmt, ...)
{
    va_list arglist;
    if ( !__glt_errfile_init && !__glt_errfile ) {
        __glt_errfile = stderr;
        __glt_errfile_init = 1;
    }
    if (__glt_errfile) {
        va_start(arglist, fmt);
        vfprintf(__glt_errfile, fmt, arglist);
        putc('\n', __glt_errfile);
        va_end(arglist);
    }
}

void
glt_fatal(char *fmt, ...)
{
    va_list arglist;
    if ( !__glt_errfile_init && !__glt_errfile ) {
        __glt_errfile = stderr;
        __glt_errfile_init = 1;
    }
    if (__glt_errfile) {
        va_start(arglist, fmt);
        vfprintf(__glt_errfile, fmt, arglist);
        putc('\n', __glt_errfile);
        va_end(arglist);
    }
    exit(1);
}

#if 0
/* Maybe have set/get rather than return old value? */

FILE *
glt_errfile(FILE *file)
{
    FILE *tmp = __glt_errfile;
    __glt_errfile = file;
    return tmp;
}

int
glt_debug_flags(int flags)
{
    int tmp = __glt_debug;
    __glt_debug = flags;
    return tmp;
}

void
glt_debug_string(char *string)
{
    glt_fatal("glt_debug_string: unimplemented function");
}
#endif
