#!/usr/common/bin/perl
#
# enums.c.pl
#
# Kekoa Proudfoot 6/22/98
#

# The enum table is a two-level lookup table that relies on the fact
# that enums are clumped.  An initial lookup is done on the msb of the
# enum; that leads to a second lookup done on the lsb of the enum.
# Furthermore, the second lookup is constrained to a range stored in the
# first lookup table.

use lib "../perl/modules";

use Includes;

use Opcodes qw(: );
use Flags   qw(: );
use Headers qw(: %enums);

print("/*\n");
print(" * enums.c\n");
print(" *\n");
print(" * Machine generated enum lookup code\n");
print(" *\n");
print(" */\n");
print("\n");

print("/* Include files */\n");
print("\n");

print("#include <stdlib.h>\n");
print("\n");

print("#include \"enums.h\"\n");
print("\n");

print("/* Typedefs */\n");
print("\n");
print("typedef struct {\n");
print("    short  index;\n");
print("    short  count;\n");
print("} GLT_enum_tab_ent;\n");
print("\n");

print("/* Global variable to control enum output format */\n");
print("\n");
print("/* Hack! */\n");
print("int __glt_text_enums = 0;\n");
print("\n");

print("/* Indirection table */\n");
print("\n");

# Find the structure of the indirection table

foreach $key (keys(%enums)) {
#    next if ($enums{$key} =~ /_SGI[SX]?$/);
#  next if ($enums{$key} =~ /^GL_(POINTS|LINES|LINE_LOOP|LINE_STRIP|TRIANGLES|TRIANGLE_STRIP|TRIANGLE_FAN|QUADS|QUAD_STRIP|POLYGON)$/ );
    $validenums{$key} = $enums{$key};
}

for ($i = 0; $i < 256; $i++) {
    $msbmax[$i] = -1;
}

@keys = sort { $a <=> $b } (keys(%validenums));

foreach $key (@keys) {
    $lsb = ($key >> 0) & 0xff;
    $msb = ($key >> 8) & 0xff;
    $msbmax[$msb] = $lsb;
}

print("static GLT_enum_tab_ent __enum_tab_ents[256] = {\n");

@counttab = ();
@indextab = ();

$first = 0;
$string = "";
for ($i = 0; $i < 256; $i++) {
    if ($msbmax[$i] < 0) {
	$count = -1;
	$index = -1;
    }
    else {
	$count = $msbmax[$i] + 1;
	$index = $first;
	$first += $count;
    }
    push(@counttab, $count);
    push(@indextab, $index);
    if ( 0 ) {
    	$string .= "$index, ";
    	if (length($string) > 65) {
    	    chop($string);
    	    print("    $string\n");
    	    $string = "";
    	}
    	$string .= "$count, ";
    	if (length($string) > 65) {
    	    chop($string);
    	    print("    $string\n");
    	    $string = "";
    	}
    } 
    else {
      $string .= "{$index, $count},";
      if (length($string) > 65) {
	print("    $string\n");
	$string ="";
      }
    }
}
if ($string ne "") {
    chop($string);
    print("    $string\n");
}
print("};\n");
print("\n");

print("/* String table */\n");
print("\n");

print("static char *__enum_str_tab[] = {\n");

foreach $key (@keys) {
}

for ($i = 0; $i < 256; $i++) {
    $count = shift(@counttab);
    $index = shift(@indextab);
    
    next if ($count < 0);

    for ($j = 0; $j < $count; $j++) {
	$key = ($i << 8) + $j;
	if (defined($validenums{$key})) {
	    $string = "\"$validenums{$key}\",";
	    printf("    %-40s  /* 0x%04x */\n", $string, $key);
	}
	else {
	    print("     NULL,\n");
	}
    }
}
print("};\n");
print("\n");

print("/* Enum name function */\n");
print("\n");

print("char *\n");
print("__glt_enum_name(GLTenum value)\n");
print("{\n");
print("    static char buf[16];\n");
print("    if (__glt_text_enums) {\n");
print("        if (value < 0x10000) {\n");
print("            int msb = value >> 8;\n");
print("            int lsb = value & 0xff;\n");
print("            GLT_enum_tab_ent *ent = &__enum_tab_ents[msb];\n");
print("            if (lsb < ent->count) {\n");
print("                char *str = __enum_str_tab[ent->index + lsb];\n");
print("                if (str)\n");
print("                    return str;\n");
print("            }\n");
print("        }\n");
print("    }\n");
print("    sprintf(buf, \"%u\", value);\n");
print("    return buf;\n");
print("}\n");
print("\n");

