#!/usr/common/bin/perl
#
# callgl.c.pl
#
# Kekoa Proudfoot 5/10/98
#

use lib "../perl/modules";

# Bleah, I prefer Include qw(shared.in), but that gives errors until 5.004
use Includes;

use Flags   qw(callgl.c.fl);

use Opcodes qw(: @ops optofn fntolb);
use Flags   qw(: %ignore %noencode %notopengl %wincall);
use Headers qw(: fntype fnpnames);
use Encode  qw(fnssize fnsname);

foreach $op (@ops) {
    $name = optofn($op);
    next if ($ignore{$name} || $noencode{$name});
    push(@names, $name);
}

print("/*\n");
print(" * callgl.c\n");
print(" *\n");
print(" * Machine generated gl call routine\n");
print(" *\n");
print(" */\n");
print("\n");

print("/* Include files */\n");
print("\n");

print("#ifdef WIN32\n");
print("#define WIN32_LEAN_AND_MEAN\n");
print("#include <windows.h>\n");
print("#endif\n");
print("#include <GL/gl.h>\n");
print("\n");
print("#include \"glt.h\"\n");
print("#include \"win.h\"\n");
print("\n");

print("/* Macros */\n");
print("\n");

print("#ifndef NDEBUG\n");
print("#define ONCE(cmd) \\\n");
print("    do { \\\n");
print("        static int once = 0; \\\n");
print("        if (!once && ++once) cmd ; \\\n");
print("    } while (0)\n");
print("#else\n");
print("#define ONCE(cmd)\n");
print("#endif\n");
print("\n");

print("#ifdef LINUX\n");
print("#define glTexSubImage2DEXT glTexSubImage2D\n");
print("#define glPolygonOffsetEXT glPolygonOffset\n");
print("#endif\n");
print("\n");

print("/* GL call routine */\n");
print("\n");

print("void\n");
print("glt_callgl(GLT_opcode op, GLT_data *data)\n");
print("{\n");
print("    switch (op) {\n");

foreach $name (@names) {
    $type = fntype($name);
    $pnames = fnpnames($name);
    $notopengl = $notopengl{$name};
    $wincall = $wincall{$name};
    $label = fntolb($name);
    $ssize = fnssize($name);
    print("        case $label:\n");

    if ($notopengl) {
	if ($wincall) {
	    $callname = $name;
	    $callname =~ s/^glt?//;
	    $callname =~ s/([^0-9])([A-Z0-9])/$1_$2/g;
	    $callname =~ tr/A-Z/a-z/;
	    $callname = "__glt_$callname";
	    if (!$ssize) {
		print("            $callname();\n");
	    }
	    else {
		$sname = fnsname($name);
		($uname = $sname) =~ s/^GLT_//;
		print("            $callname(&data->$uname);\n");
	    }
	}
	else {
	    print("            ONCE(glt_mesg(GLT_CWARN, \"glt_callgl: ignoring $name\"));\n");
	}
	print("            break;\n");
    }
    elsif (!$ssize) {
	# Would map EXT for WIN32 here, but no such functions have zero $ssize
	print("            $name();\n");
	print("            break;\n");
    }
    else {
	print("        {\n");
	$sname = fnsname($name);
	($uname = $sname) =~ s/^GLT_//;
	print("            $sname *d = &data->$uname;\n");
	@pnames = split(', ', $pnames);
	@cnames = ();
	foreach $pname (@pnames) {
	    push(@cnames, "d->$pname");
	}
	$cnames = join(', ', @cnames);
	# Map EXT functions to non-EXT for WIN32
	if ($name =~ /EXT$/) {
	    ($win32name = $name) =~ s/EXT$//;
	    print("            /* Hack? */\n");
	    print("#ifdef WIN32\n");
	    print("            $win32name($cnames);\n");
	    print("#else\n");
	    print("            $name($cnames);\n");
	    print("#endif\n");
	}
	else {
	    print("            $name($cnames);\n");
	}
	print("            break;\n");
	print("        }\n");
    }
}
print("    default:\n");
print("        glt_fatal(\"glt_callgl: invalid opcode %d\", op);\n");
print("        break;\n");
print("    }\n");
print("}\n");

