'''OpenGL extension SGIX.depth_texture

Overview (from the spec)
	
	This extension defines a new depth texture format.  An important
	application of depth texture images is shadow casting, but separating
	this from the shadow extension allows for the potential use of depth
	textures in other applications such as image-based rendering or
	displacement mapping.  This extension does not define new depth-texture
	environment functions, such as filtering or applying the depth values
	computed from a texture, but leaves this to other extensions, such as
	the shadow extension.

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/SGIX/depth_texture.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SGIX_depth_texture'
_DEPRECATED = False
GL_DEPTH_COMPONENT16_SGIX = constant.Constant( 'GL_DEPTH_COMPONENT16_SGIX', 0x81A5 )
GL_DEPTH_COMPONENT24_SGIX = constant.Constant( 'GL_DEPTH_COMPONENT24_SGIX', 0x81A6 )
GL_DEPTH_COMPONENT32_SGIX = constant.Constant( 'GL_DEPTH_COMPONENT32_SGIX', 0x81A7 )


def glInitDepthTextureSGIX():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
