#
# shared Makefile
#
# Kekoa Proudfoot
# 6/17/98
#

# architecture

ARCH=WIN32
ifneq ($(findstring $(shell uname),IRIX IRIX64),)
    ARCH=IRIX
else
    ifneq ($(findstring $(shell uname),Linux),)
        ARCH=LINUX
    endif
endif

# special targets

.PHONY: all clean links
.PRECIOUS: %.o %.c %.cpp

# pattern rules

ifeq ($(ARCH),IRIX)
%: %.c
%: %.cpp
%: %.o
%.o: %.c
	cc $(CFLAGS) $(INCS) -c $*.c
%.o: %.cpp
	CC $(CFLAGS) $(INCS) -c $*.cpp
%: %.o
	CC $(LFLAGS) -o $* $(filter %.o,$^) $(filter %.a,$^) $(LIBS)
%.a: %.o
%.a:
	rm -f $*.a
	ar rc $*.a $(filter %.o,$^)
%.d: %.c
	perl $(ROOT)/make/fastdep.pl $*.c > $*.d
%.d: %.cpp
	perl $(ROOT)/make/fastdep.pl $*.cpp > $*.d
endif

ifeq ($(ARCH),LINUX)
%: %.c
%: %.cpp
%: %.o
%.o: %.c
	gcc $(CFLAGS) $(INCS) -c $*.c
%.o: %.cpp
	g++ $(CFLAGS) $(INCS) -c $*.cpp
%: %.o
	g++ $(LFLAGS) -o $* $(filter %.o,$^) $(filter %.a,$^) $(LIBS)
%.a: %.o
%.a:
	rm -f $*.a
	ar rc $*.a $(filter %.o,$^)
%.d: %.c
	perl $(ROOT)/make/fastdep.pl $*.c > $*.d
%.d: %.cpp
	perl $(ROOT)/make/fastdep.pl $*.cpp > $*.d
endif

ifeq ($(ARCH),WIN32)
%: %.c
%: %.cpp
%: %.o
%.o: %.c
	cl -nologo $(CFLAGS) $(INCS) -c $*.c -Fo$*.o
%.o: %.cpp
	cl -nologo $(CFLAGS) $(INCS) -c $*.cpp -Fo$*.o
%.exe: %.o
	link -nologo $(LFLAGS) -out:$*.exe $(filter %.o,$^) $(filter %.lib,$^) $(LIBS)
%.lib: %.o
%.lib:
	lib -nologo $(LIBFLAGS) -out:$*.lib $(filter %.o,$^)
%.d: %.c
	perl $(ROOT)/make/fastdep.pl $*.c > $*.d
%.d: %.cpp
	perl $(ROOT)/make/fastdep.pl $*.cpp > $*.d
endif

# common pattern rules

%.c: %.y
%.c: %.l
	flex -tl $*.l > $*.c
%.c: %.y
	bison -d $*.y
	mv -f $*.tab.c $*.c
	mv -f $*.tab.h $*.th
%.c: %.c.pl
	perl $*.c.pl > $*.c
%.h: %.h.pl
	perl $*.h.pl > $*.h

# includes

#-include $(ROOT)/make/config.mk  # do not modify this file
#-include $(ROOT)/Config          # override config.mk here
