/****************************************************************************

Some simple code for dealing with vectors.

Ravi Ramamoorthi: May 22, 2002

***************************************************************************/

#include <math.h>

inline double dotp(const double v1[3], const double v2[3]) {
  return v1[0]*v2[0]+v1[1]*v2[1]+v1[2]*v2[2] ;
}

inline double dotptrunc(double *a, double *b) {
  double retval = 0 ;
  for (int i = 0 ; i < 3 ; i++) retval += a[i]*b[i] ;
  if (retval < 0) retval = 0 ;
  return retval ;
}


inline void  reflectionvector(double surf[3], double camloc[3], double refvec[3]) {
  
  int i ;
  double d ;
  d = dotp(surf,camloc) ;
  for (i = 0 ; i < 3 ; i++)
    refvec[i] = 2*d*surf[i]-camloc[i] ;
  if (fabs(refvec[2])>1.0) refvec[2] *= .999 ;
  
}

inline void halfangle(double refvec[3], double camloc[3], double halfvec[3]) {
  int i ;
  double d = 0 ;
  for (i = 0 ; i < 3 ; i++) {
    halfvec[i] = camloc[i]+refvec[i] ;
    d += halfvec[i]*halfvec[i] ;
  }
  d = sqrt(d) ;
  if (fabs(d)<.0001) {
    for (i = 0 ; i < 3 ; i++)
      halfvec[i] = camloc[i] ;
    return ;
  }
  for (i = 0 ; i < 3 ; i++) halfvec[i] /= d ;
  return ;
}

inline void VecNormalize(double *v) {
  double d = sqrt(dotp(v,v)) ;
  if (fabs(d) < 1.0e-6) d = 1.0 ;
  for (int i = 0 ; i < 3 ; i++) v[i] /= d ;
}

