/****************************************************************************

A bunch of utility routines to convert to and from spherical harmonics.

Ravi Ramamoorthi: May 22, 2002

***************************************************************************/

#include <stdio.h>
#include <math.h>
#include <complex>
#include <assert.h>
#include "legendre.h"
#include "globals.h"
#include "transforms.h"


int cosineseries(double fit[maxphi], double fitcoeffs[maxl+1]) {
  int i,j ;
  int ctr ;
  for (i = 0 ; i <= maxp ; i++) {  // Changed from maxl -- Ravi.
    double sum = 0 ;
    ctr = 0 ;
    for (j = 0 ; j < maxphi ; j++) {
      if (1 /* valid[j] */) {
	  sum += fit[j]*cosphi[(i*j)%maxphi]*sqrtpi/maxphi ;
	  ++ctr ; 
	}
    }
    if (ctr != 0) fitcoeffs[i] = 2.0*M_PI*sum*maxphi/ctr ;
    else fitcoeffs[i] = 0 ;
  }
  return ctr ;
}

void cosineunroll(double fitcoeffs[maxl+1], double fit[maxphi]) {
  int i,j ;
  for (i = 0 ; i < maxphi ; i++) {
    double sum = 0 ;
    for (j = 0 ; j <= maxl ; j++) {
      sum += fitcoeffs[j]*cosphi[(i*j)%maxphi] ;
    }
    fit[i] = sum ;
  }
}

complex<double> integratephi(int m, double fn[maxphi]) {
  complex<double> retval = 0 ;
  double mulfac = 2.0*M_PI/maxphi ;
  complex <double> expphimine(cos((double) 2.0*M_PI*m/((double) maxphi)),-sin((double) 2.0*M_PI*m/((double) maxphi))) ;
  complex <double> exponent(1,0) ;
  assert(maxphi%2==0) ;
  for (int i = 0 ; i < maxphi ; i++) {
    retval += exponent*mulfac*fn[i] ;
    exponent *= expphimine ;
  }
  return retval ;
}

complex<double> integratetheta(int l, int m, complex<double> fn[maxtheta]) {
  complex<double> retval = 0 ;
  double mulfac = M_PI/maxtheta ;
  for (int i = 0 ; i < maxtheta ; i++) {
    retval += fn[i]*sintheta[i]*mulfac*plmval(l,m,i) ;
  }
  return retval ;
}

void makereal(const complex<double> coeffscomplex[maxl+1][2*maxl+1], double coeffsreal[maxl+1][2*maxl+1]) {
  const double invrt2 = 1.0/sqrt(2) ;
  int k,l ;
  complex<double> coeffscomplextmp[maxl+1][2*maxl+1] ;
      for (k = 0 ; k <= maxl ; k++)
	for (l = -k ; l <= k ; l++) 
	  coeffscomplextmp[k][l+maxl] = coeffscomplex[k][l+maxl] ;

      for (k = 0 ; k <= maxl ; k++)
	for (l = 1 ; l <= k ; l++) {
	  double Aminus, Aplus, Bminus, Bplus ;
	  double Asum, Adiff, Bsum, Bdiff ;
	  Aplus = coeffscomplex[k][maxl+l].real() ;
	  Bplus = coeffscomplex[k][maxl+l].imag() ;
	  Aminus= coeffscomplex[k][maxl-l].real() ;
	  Bminus= coeffscomplex[k][maxl-l].imag() ;
	  int sgn ;
	  if (l % 2 == 0) sgn = 1 ; else sgn = -1 ;
	  Asum = invrt2*(Aplus+sgn*Aminus) ;
	  Bsum = invrt2*(-Bplus+sgn*Bminus);
	  Adiff= invrt2*(Aplus-sgn*Aminus) ;
	  Bdiff= invrt2*(Bplus+sgn*Bminus) ;
	  coeffscomplextmp[k][maxl+l] = complex<double>(Asum,Bdiff) ;
	  coeffscomplextmp[k][maxl-l]= complex<double>(Bsum,Adiff) ;
	}
      for (k = 0 ; k <= maxl ; k++)
	for (l = -k ; l <= k ; l++) {
	  complex<double>z = coeffscomplextmp[k][l+maxl] ;
	  assert(fabs(z.imag())<.1) ;
	  coeffsreal[k][l+maxl] = z.real() ;
	}
}

void findcoeffslmcomplex(double fn[maxtheta][maxphi], complex<double> coeffs[maxl+1][2*maxl+1]) {
  complex<double> fnt[2*maxl+1][maxtheta] ;
  int l,m,i ;
  for (m = -maxl ; m <= maxl ; m++) {
    for (i = 0 ; i < maxtheta ; i++) {
      fnt[m+maxl][i] = integratephi(m,fn[i]) ;
    }
  }
  for (l = 0 ; l <= maxl ; l++) {
    for (m = -l ; m <= l ; m++) {
      coeffs[l][m+maxl] = integratetheta(l,m,fnt[m+maxl]) ;
    }
  }
}

void findcoeffslm(double fn[maxtheta][maxphi], double coeffs[maxl+1][2*maxl+1]) {
  complex <double> fnt[maxl+1][2*maxl+1] ;
  findcoeffslmcomplex(fn,fnt) ;
  makereal(fnt,coeffs) ;
}


void findcoeffs(double fit[maxtheta][maxtheta][maxphi], double fitcoeffs[maxl+1][maxl+1][maxl+1]) {
  double tmp1[maxtheta][maxtheta][maxl+1] ;
  int count1[maxtheta][maxtheta] ;
  double tmp2[maxtheta][maxl+1][maxl+1] ;
  int count2[maxtheta] ;
  int i,j,k,l ;
  for (i = 0 ; i < maxtheta ; i++)
    for (j = 0 ; j < maxtheta ; j++)
      count1[i][j] = cosineseries(fit[i][j],tmp1[i][j]) ;

    for (k = 0 ; k <= maxp ; k++) {
      for (j = k ; j <= maxp ; j++) {
	for (i = 0 ; i < maxtheta ; i++) {
	  double sum = 0 ;
	  int ctr1 = 0 ; 
	  for (l = 0 ; l < maxtheta ; l++) {
	    sum += sintheta[l]*M_PI*tmp1[i][l][k]*plmvalreal(j,k,l)*count1[i][l] ;
	    ctr1 += count1[i][l] ;
	  }
	  if (ctr1 == 0) tmp2[i][j][k] = 0 ;
	  else tmp2[i][j][k] = sum/ctr1 ;
	  count2[i] = ctr1 ;
	}
      }
    }

    for (k = 0 ; k <= maxp ; k++) {
      for (j = k ; j <= maxp ; j++) {
	for (i = k ; i <= maxl ; i++) {
	  double sum = 0 ;
	  int ctr = 0 ;
	  for (l = 0 ; l < maxtheta ; l++) {
	    sum += sintheta[l]*M_PI*tmp2[l][j][k]*plmvalreal(i,k,l)*count2[l] ;
	    ctr += count2[l] ;
	  }
	  assert(ctr) ;
	  if (k == 0) fitcoeffs[i][j][k] = sqrt(2)*sum/ctr ;
	  else fitcoeffs[i][j][k] = sum/ctr ;
	}
      }
    }
}

void unrollcoeffs(double fitcoeffs[maxl+1][maxl+1][maxl+1], double fit[maxtheta][maxtheta][maxphi]) {
  double tmp1[maxtheta][maxl+1][maxl+1] ;
  double tmp2[maxtheta][maxtheta][maxl+1] ;
  int l,p,q,i,j;
  // I need to fix this....

  for (i = 0 ; i <= maxl ; i++)
    for (j = 0 ; j <= maxl ; j++)
      cosineunroll(fitcoeffs[i][j],tmp1[i][j]) ;

  for (q = 0 ; q <= maxl ; q++)
    for (p = q ; p <= maxl ; p++)
      for (i = 0 ; i < maxtheta ; i++) {
	double sum = 0 ;
	for (l = q ; l <= maxl ; l++) {
	  sum += plmvalreal(l,q,i)*fitcoeffs[l][p][q] ;
	}
	tmp1[i][p][q] = sum ;
      }

  for (q = 0 ; q <= maxl ; q++)
    for (i = 0 ; i < maxtheta ; i++)
      for (j = 0 ; j < maxtheta ; j++) {
	double sum = 0 ;
	for (p = q ; p <= maxl ; p++) {
	  sum += plmvalreal(p,q,j)*tmp1[i][p][q] ;
	}
	tmp2[i][j][q] = sum ;
      }

  for (i = 0 ; i < maxtheta ; i++)
    for (j = 0 ; j < maxtheta ; j++)
      cosineunroll(tmp2[i][j],fit[i][j]) ;
}

void printcoeffs(double coeffs[maxl+1][maxl+1][maxl+1]) {
  int l,p,q ;
  for (l = 0 ; l <= maxl ; l++)
    for (p = 0 ; p <= maxl ; p++)
      for (q = 0 ; q <= maxl ; q++) {
	if (q > p || q > l) continue ;
	//if ((l+q)%2==0 || (p+q)%2==0) continue;
	//	if (fabs(coeffs[l][p][q])>2.0) 
	  printf("%4d %4d %4d %12.6lf\n",l,p,q,coeffs[l][p][q]) ;
      }
}

void readd(char * filename) {
  FILE * fp ;
  assert(fp = fopen(filename,"rt")) ;
  int l,j,q ;
  int a ;
  int step = 1 ; // 100/maxtheta ;
  for (l = 0 ; l <= ((maxl >= 20) ? 20: maxl) ; l++)
    for (a = 0 ; a < 100 ; a++) {
      int tmp1, tmp2 ;
      fscanf(fp,"%d %d",&tmp1,&tmp2) ;
      assert(tmp1 == l) ; assert(tmp2 == a) ;
      for (j = -l ; j <= l ; j++)
	for (q = -l ; q <= l ; q++) {
	  double tmp ;
	  fscanf(fp,"%lf ",&tmp) ;
	  if (a%step==0) {
	    D[l][maxl+j][maxl+q][a/step] = tmp ;
	    // D[l][maxl+j][maxl+q][a/step] *= sqrt((2*l+1)/(4*M_PI)) ;
	  }
	}
    }
}

/*
double Dval(int l, int m, int q, double theta) {
  double aval = theta/M_PI*100.0 ;
  if (aval > 99) aval = 98.9999 ;
  int aint ; double afrac ;
  aint = (int) aval ;
  afrac = aval - aint ;
  assert(aint >= 0 && aint < 99) ;
  return (1-afrac)*D[l][m+maxl][q+maxl][aint]+afrac*D[l][m+maxl][q+maxl][1+aint] ;
}
*/

/*
double Dval(int l, int m, int q, int theta) {
  int divfac ;
  assert(maxtheta == 200) ;
  assert (theta >= 0 && theta <= maxtheta-1) ;
  if (l > 20) return 0 ;
  if (theta % 2 == 0) return D[l][maxl+m][maxl+q][theta/2] ;
  else return (D[l][maxl+m][maxl+q][theta/2] + D[l][maxl+m][maxl+q][1+theta/2])/2.0 ;
}
*/

double Dval(int l, int m, int q, int theta) {
  assert (theta >= 0 && theta <= maxtheta-1) ;
  if (l > 20) return 0 ;
  return D[l][m+maxl][q+maxl][theta] ;
}
