/****************************************************************************

This code contains various functions performed on SHRMs.

Ravi Ramamoorthi: May 22, 2002

***************************************************************************/

#include <stdio.h>
#include <math.h>
#include <complex>
#include <assert.h>
#include "legendre.h"
#include "globals.h"
#include "transforms.h"

//--------------------------------------------------------------------------
// Create the azimuthally independent reflection maps of Kautz et al., which
// correspond for us to setting terms with q <> 0 to 0.

void kautzify(double coeffs[maxl+1][maxl+1][maxl+1]) {
  int l,p,q ;
  for (l = 0 ; l <= maxl ; l++)
    for (p = 0 ; p <= maxp ; p++)
      for (q = 0 ; q <= maxp ; q++) {
	if (q == 0) continue ;
	coeffs[l][p][q] = 0 ;
      }
}

//--------------------------------------------------------------------------
// Go from the coefficients B_{lmpq} in refcoeffs to the (global) SHRM
// B_{pq}(alpha,beta) in refmap [equation 14 in Appendix A of paper]
// The computation follows step 3 of the algorithm in Appendix C .

void createreflectionmap (
 double refcoeffs[maxl+1][2*maxl+1][maxl+1][2*maxl+1][3], 
 double refmap[maxtheta][maxphi][maxp+1][2*maxp+1][3] ) 
{
  const double rt2 = sqrt(2.0) ;
  int l,m,p,q,j,th,ph ;

  // Expand over index l

  for (th = 0 ; th < maxtheta ; th++) {
    for (l = 0 ; l <= mymaxl ; l++) {
      double lmul = sqrt(4.0*M_PI/(2.0*l+1)) ;
      for (m = -l ; m <= l ; m++)
	for (p = 0 ; p <= maxp ; p++)
	  for (q = -p ; q <= p ; q++) {
	    if (fabs(q)>l) continue ;
	    int mindex = m ;
	    if (m < 0) mindex *= -1 ;
	    int sgnflag ;
	    if (m < 0) sgnflag = -1 ;
	    else sgnflag = 1 ;
	    
	    double basisfn1, basisfn2 ;
	      basisfn1 =  Dval(l, m,q,th) ;
	      basisfn2 = -sgnflag*Dval(l,-m,q,th) ;
	    for (j = 0 ; j < 3 ; j++) {
	      costmp[th][mindex][p][q+maxp][j] += 
		basisfn1*refcoeffs[l][m+maxl][p][q+maxl][j] ;
	      sintmp[th][mindex][p][q+maxp][j] += 
		basisfn2*refcoeffs[l][m+maxl][p][q+maxl][j] ;
	    }
	  }
    }
  }

  // Expand over index m

  for (th = 0 ; th < maxtheta ; th++)
    for (ph = 0 ; ph < maxphi ; ph++)
      for (m = 0 ; m <= mymaxl ; m++) {
	int bb = (m*ph)%maxphi ;
	for (p = 0 ; p <= maxp ; p++)
	  for (q = -p ; q <= p ; q++) 
	    for (j = 0 ; j < 3 ; j++) {
	      refmap[th][ph][p][q+maxp][j] += 
		 costmp[th][m][p][q+maxp][j]*cosphi[bb]+
                 sintmp[th][m][p][q+maxp][j]*sinphi[bb] ;
	    }
      }

  // Checking routines...
  int a,b,to,po,col ;

  a = 17 ; b = 23 ; to = 42 ; po = 21 ; col = 0 ;
  double val1 = 0 ;
  for (p = 0 ; p <= maxp ; p++)
    for (q = -p ; q <= p ; q++) {
      val1 += Yreal(p,q,to,po)*refmap[a][b][p][q+maxp][col] ;
    }

  double val2 = 0 ;
  for (l = 0 ; l <= mymaxl ; l++)
    for (m = -l ; m <= l ; m++)
      for (p = 0 ; p <= maxp ; p++)
	for (q = -p ; q <= p ; q++) {

	  int mindex = m ;
	  if (m < 0) mindex *= -1 ;
	  int sgnflag ;
	  if (m < 0) sgnflag = -1 ;
	  else sgnflag = 1 ;

	  int bb = ((int) (mindex*b))%maxphi ;
	  
	  double basisfn ;
	  /*	  if (q == 0)  basisfn = Yreal(p,q,to,po)*Yreal(l,m,a,b)*sqrt(4.0*M_PI/(2.0*l+1));*/
	  //	  else 
	    basisfn = Yreal(p,q,to,po)*(Dval(l,m,q,a)*cosphi[bb] - sgnflag*Dval(l,-m,q,a)*sinphi[bb]) ;

	  val2 += refcoeffs[l][m+maxl][p][q+maxl][col]*basisfn ;	  
	}
  printf("%d %d %d %d %d || V1: %lf V2: %lf\n",a,b,to,po,col, val1,val2) ;
  // A check that everything is working correctly.
}

//----------------------------------------------------------------------------
// Convert to local SHRM (real form of equation 8)
//----------------------------------------------------------------------------

void warpreflectionmap(double refmap[maxtheta][maxphi][maxp+1][2*maxp+1][3], double refwarp[maxtheta][maxphi][maxp+1][2*maxp+1][3])
{
  int l,m,a,b,p,q,j,col ;

  for (a = 0 ; a < maxtheta ; a++) 
    for (b = 0 ; b < maxphi ; b++)
      for (p = 0 ; p <= maxp ; p++)
	for (q = -p ; q <= p; q++)
	  for (m=-p ; m <= p; m++)
	  for (j = 0 ; j < 3; j++)
	  {
	  int qindex = (q >= 0) ? q : -q ;
	  int mindex = (m >= 0) ? m : -m ;
	  double sgnflag = pow(-1,qindex) * pow(-1,mindex) ;
	  double sgnflag2 ;
	  if (q < 0) sgnflag2 = -1 ; else sgnflag2 = 1 ;
	  int bb = (qindex*b)%maxphi ;

	  double t = sgnflag*refmap[a][b][p][m+maxp][j]*Dval(p,m,q,a) ;
	  

	  refwarp[a][b][p][ q+maxp][j] += t*cosphi[bb] ;
	  refwarp[a][b][p][-q+maxp][j] += t*sinphi[bb]*sgnflag2 ;	    
	  }

  double th,ph,to,po ;
	   	  
  // Checking routines:
  a = 17 ; b = 23 ; to = 17 ; po = maxphi/2 ; col = 0 ; th = 0 ; ph = 0 ;
  double val1 = 0 ; 
  for (p = 0 ; p <= maxp ; p++)
    for (q = -p ; q <= p ;q++) {
      
      //      printf("%d %d refmap %lf rz %lf refwarp %lf val1 %lf val2 %lf\n",p,q,              refmap[a][b][p][q+maxp][col], rz[a][b][p][q+maxp][col],                        refwarp[a][b][p][q+maxp][col],                                        	  refmap[a][b][p][q+maxp][col]*Yreal(p,q,to,po),                                 refwarp[a][b][p][q+maxp][col] * Yreal(p,q,th,ph) ) ;
           
      val1 += refmap[a][b][p][q+maxp][col]  * Yreal(p,q,to,po) ;
    }
  double val2 = 0 ;
  for (p = 0 ; p <= maxp ; p++)
    for (q = -p ; q <= p ;q++) 
      val2 += refwarp[a][b][p][q+maxp][col] * Yreal(p,q,th,ph) ;
  
  printf("%d %d %d %d %d || V1: %lf V2: %lf\n",a,b,(int)to,(int)po,col, val1,val2) ;
}

//-----------------------------------------------------------------------------
// Same as above, but includes code for Katuz's azimuthally independent refmaps
//-----------------------------------------------------------------------------

void warpreflectionmap(double refmap[maxtheta][maxphi][maxp+1][2*maxp+1][3], double refwarp[maxtheta][maxphi][maxp+1][2*maxp+1][3], double kautzrefwarp[maxtheta][maxphi][maxp+1][2*maxp+1][3])
{
  int l,m,a,b,p,q,j,col ;

  for (p = 0 ; p <= maxp ; p++) {
    for (q = -p ; q <= p; q++) {
    double sgnflag2 ;
    if (q < 0) sgnflag2 = -1 ; else sgnflag2 = 1 ;
    int qindex = (q >= 0) ? q : -q ;
    for (m=-p ; m <= p; m++) {
      int mindex = (m >= 0) ? m : -m ;
      double sgnflag = pow(-1,qindex) * pow(-1,mindex) ;	  
      for (a = 0 ; a < maxtheta ; a++) {
	double t1 = sgnflag*Dval(p,m,q,a) ;
	double t2 = t1*sgnflag2 ;
	int bb = 0 ;
	for (b = 0 ; b < maxphi ; b++) {
	  double *v = refmap[a][b][p][m+maxp] ;
	  double *r1 = refwarp[a][b][p][q+maxp] ;
	  double *r2 = refwarp[a][b][p][-q+maxp] ;
	  double *k1, *k2 ;
	  if (m == 0) {
	      k1 = kautzrefwarp[a][b][p][q+maxp] ;
	      k2 = kautzrefwarp[a][b][p][-q+maxp] ;
	  }
	  double s1, s2 ;
	  s1 = t1*cosphi[bb] ; s2 = t2*sinphi[bb] ;
	  for (j = 0 ; j < 3; j++) {
	    double valcos = v[j]*s1 ;
	    double valsin = v[j]*s2 ;
	    /*
	    double myt = sgnflag*refmap[a][b][p][m+maxp][j]*Dval(p,m,q,a) ;
	    assert(fabs(valcos - myt*cosphi[bb]) < 1.0e-4) ;
	    assert(fabs(valsin - myt*sinphi[bb]*sgnflag2) < 1.0e-4) ;
	    */
	    r1[j] += valcos ; r2[j] += valsin ;
	      if (m == 0) {
		k1[j] += valcos ; k2[j] += valsin ;
	      }		  
	  }
	  bb = (bb+qindex)%maxphi ;
	}
      }
    }
    }
  }

  /*
  for (a = 0 ; a < maxtheta ; a++) 
    for (b = 0 ; b < maxphi ; b++)
      for (p = 0 ; p <= maxp ; p++)
	for (q = -p ; q <= p; q++)
	  for (m=-p ; m <= p; m++) 
	  for (j = 0 ; j < 3; j++)
	  {
	  int qindex = (q >= 0) ? q : -q ;
	  int mindex = (m >= 0) ? m : -m ;
	  double sgnflag = pow(-1,qindex) * pow(-1,mindex) ;
	  double sgnflag2 ;
	  if (q < 0) sgnflag2 = -1 ; else sgnflag2 = 1 ;
	  int bb = (qindex*b)%maxphi ;

	  double t = sgnflag*refmap[a][b][p][m+maxp][j]*Dval(p,m,q,a) ;
	  

	  refwarp[a][b][p][ q+maxp][j] += t*cosphi[bb] ;
	  refwarp[a][b][p][-q+maxp][j] += t*sinphi[bb]*sgnflag2 ;
	  
	  if (m == 0) {
	    kautzrefwarp[a][b][p][ q+maxp][j] += t*cosphi[bb] ;
	    kautzrefwarp[a][b][p][-q+maxp][j] += t*sinphi[bb]*sgnflag2 ;
	  }
	  }
  */

  double th,ph,to,po ;
	   	  
  // Checking routines:
  a = 17 ; b = 23 ; to = 17 ; po = maxphi/2 ; col = 0 ; th = 0 ; ph = 0 ;
  double val1 = 0 ; 
  for (p = 0 ; p <= maxp ; p++)
    for (q = -p ; q <= p ;q++) {
      
      //      printf("%d %d refmap %lf rz %lf refwarp %lf val1 %lf val2 %lf\n",p,q,              refmap[a][b][p][q+maxp][col], rz[a][b][p][q+maxp][col],                        refwarp[a][b][p][q+maxp][col],                                        	  refmap[a][b][p][q+maxp][col]*Yreal(p,q,to,po),                                 refwarp[a][b][p][q+maxp][col] * Yreal(p,q,th,ph) ) ;
           
      val1 += refmap[a][b][p][q+maxp][col]  * Yreal(p,q,to,po) ;
    }
  double val2 = 0 ;
  for (p = 0 ; p <= maxp ; p++)
    for (q = -p ; q <= p ;q++) 
      val2 += refwarp[a][b][p][q+maxp][col] * Yreal(p,q,th,ph) ;
  
  printf("%d %d %d %d %d || V1: %lf V2: %lf\n",a,b,(int)to,(int)po,col, val1,val2) ;
}
