/****************************************************************************

The main code of the program.  Inputs are a tabulated form of the BRDF and 
the illumination.  Output is an SHRM. 

Ravi Ramamoorthi: May 22, 2002

***************************************************************************/

#include <iostream.h>
#include <iomanip.h>
#include <complex>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include "legendre.h"
#include <time.h>
#include <fstream.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#undef EXTERN
#define EXTERN 
#include "globals.h"
#include "transforms.h"
#include "vectors.h"
#include "shrm.h"
#include "write.h"
#include "brdfs.h"

main(int argc, char ** argv) {

  FILE *fp1 ;
  int i,j,k,l,m,p,q ;
  struct timeval tv ;
  struct timezone tz ;
  gettimeofday(&tv,&tz) ;
  fprintf(stderr,"Checkpoint1: %ld %ld\n", tv.tv_sec, tv.tv_usec) ;
  
  //----------------------------------------------------------------------
  /* Note that this is a precomputation for entire sequence of commands.
     At present, these are called at each execution, but this could easily
     be optimized. */

  setuplegendre() ;  // Set up the Numerical values for spherical harmonics
  readd("Dvalsreal20.out") ;  // Read numerical values for D matrix
  //----------------------------------------------------------------------

  //----------------------------------------------------------------------
  /*
    The parameters are as follows:
    lightfile: Incident illumination spherical harmonic coefficients
    baseout: base for output files generated
    mulfac: Scaling factor for output file
    brdftype: sigma (N.H), lafortune, curet, mccool, kaykajiya
    options: different for each of the brdf types
   */

  if (argc < 6) {
    fprintf(stderr,"refenvshrm lightfile baseout mulfac brdftype options\n") ;
    exit(1) ;
  }
  //---------------------------------------------------------------------


  gettimeofday(&tv,&tz) ;
  fprintf(stderr,"Checkpoint2: %ld %ld\n", tv.tv_sec, tv.tv_usec) ;

  mulfac = atof(argv[3]) ;
  assert(fp1 = fopen(argv[1],"rt")) ; // light file

  
  for (l = 0 ; l <= maxl ; l++) 
    for (m = -l ; m <= l ; m++) {
      fscanf(fp1,"%d %d %lf %lf %lf",&i,&j,&(lightcoeffs[0][l][m+maxl]),&(lightcoeffs[1][l][m+maxl]),&(lightcoeffs[2][l][m+maxl])) ;
      assert(i == l) ; assert(j == m) ;
    }
    

  /*
  // ------------------------------------------------------------
  // This is a temporary hack that may be uncommented 
  // to allow us to do angular lightings
  // Note the last line; findcoeffslm finds the spherical harmonic coeffs.

  int divfac = sampfac*sampfac ;
  FILE *fp2 ;
  assert(fp2 = fopen("myfloat.out","rb")) ;

  for (i = 0 ; i < sampwidth ; i++)
    for (j = 0 ; j < sampwidth ; j++) 
      for (k = 0 ; k < 3 ; k++) {
	float val ;
	unsigned char *c = (unsigned char *) (&val) ;
	fscanf(fp2,"%c%c%c%c",&(c[3]),&(c[2]),&(c[1]),&(c[0])) ;
	floatfile[k][i][j] = val ;
      }

  for (i = 0 ; i < mysamp ; i++)
    for (j = 0 ; j < mysamp ; j++) 
      for (k = 0 ; k < 3 ; k++) {
	sampfile[k][i][j] = 0 ;
	for (l = 0 ; l < sampfac ; l++)
	  for (m = 0 ; m < sampfac ; m++)
	    sampfile[k][i][j] += 1.0/divfac*floatfile[k][i*sampfac+l][j*sampfac+m] ;
      }
      
  for (k = 0 ; k < 3 ; k++) findcoeffslm(sampfile[k],lightcoeffs[k]) ;
  // ------------------------------------------------------------
  */

  double brdfnorm[3] ; // Total energy of the BRDF

  //-----------------------------------------------------------------------
  // These are various input BRDF models 

  if (!strcmp(argv[4],"sigma")) sigma(argc-4,argv+4,brdfnorm) ;
  else if (!strcmp(argv[4],"lafortune")) lafortune(argc-4,argv+4,brdfnorm) ;
  else if (!strcmp(argv[4],"curet")) curet(argc-4,argv+4,brdfnorm) ;
  else if (!strcmp(argv[4],"mccool")) mccool(argc-4,argv+4,brdfnorm) ;
  else if (!strcmp(argv[4],"kaykajiya")) kaykajiya(argc-4,argv+4,brdfnorm) ;

  else {
    fprintf(stderr,"Unknown BRDF type.\n") ;
    exit(1) ;
  }

  fprintf(stderr,"BRDF norm is %lf %lf %lf\n",brdfnorm[0],brdfnorm[1],brdfnorm[2]) ;

  //-----------------------------------------------------------------------

  gettimeofday(&tv,&tz) ;
  fprintf(stderr,"Checkpoint3: Last Inputs: %ld %ld\n", tv.tv_sec, tv.tv_usec) ;

  for (i = 0 ; i < 3 ; i++) findcoeffs(brdf[i],brdfcoeffs[i]) ;
  // Find BRDF coefficients

  gettimeofday(&tv,&tz) ;
  fprintf(stderr,"Checkpoint4: BRDF coeffs: %ld %ld\n", tv.tv_sec, tv.tv_usec) ;

  //-----------------------------------------------------------------------
  // Finds the appropriate order for capturing fracerr of the energy.

    double coeffnorm[3] = {0,0,0} ;
    int mymaxlflag[3] = {0,0,0} ;
    int mymaxpflag[3] = {0,0,0} ;
    double fracerr = 0.97 ;

    for (l = 0 ; l < 3 ; l++) {
      for (j = 0 ; j <= maxp ; j++)
        for (k = 0 ; k <= maxp ; k++) 
          for (i = 0 ; i <= maxl ; i++) {
            if (k > j || k > i) continue ;
            coeffnorm[l] += brdfcoeffs[l][i][j][k]*brdfcoeffs[l][i][j][k] ;
            if (coeffnorm[l]/brdfnorm[l] > fracerr && mymaxpflag[l] == 0) {
              mymaxpflag[l] = j ;
            }
          }
    }  

    fprintf(stderr,"Coefficient norm is %lf %lf %lf Percentage accuracy is %lf %lf %lf mymaxp is %d %d %d\n",coeffnorm[0],coeffnorm[1],coeffnorm[2],100.0*coeffnorm[0]/brdfnorm[0],100.0*coeffnorm[1]/brdfnorm[1],100.0*coeffnorm[2]/brdfnorm[2],mymaxpflag[0],mymaxpflag[1],mymaxpflag[2]) ;

    mymaxp = mymaxpflag[0] ;
    if (mymaxpflag[1] > mymaxp) mymaxp = mymaxpflag[1] ;
    if (mymaxpflag[2] > mymaxp) mymaxp = mymaxpflag[2] ;
    //if (mymaxp > 6) mymaxp = 6 ; // If we want to limit the max val of p
    if (mymaxp == 0) 
      mymaxp = maxp ;

    for (l = 0 ; l < 3 ; l++) {
      coeffnorm[l] = 0 ;
      for (i = 0 ; i <= maxl ; i++)
        for (j = 0 ; j <= mymaxpflag[l] ; j++)
          for (k = 0 ; k <= mymaxpflag[l] ; k++) {
            if (k > j || k > i) continue ;
            coeffnorm[l] += brdfcoeffs[l][i][j][k]*brdfcoeffs[l][i][j][k] ;
            if (coeffnorm[l]/brdfnorm[l] > fracerr && mymaxlflag[l] == 0) {
              mymaxlflag[l] = i ;
          }
          }
    }
    fprintf(stderr,"Coefficient norm is %lf %lf %lf mymaxl is %d %d %d\n",coeffnorm[0],coeffnorm[1],coeffnorm[2],mymaxlflag[0],mymaxlflag[1],mymaxlflag[2]) ;

    mymaxl = mymaxlflag[0] ;
    if (mymaxlflag[1] > mymaxl) mymaxl = mymaxlflag[1] ;
    if (mymaxlflag[2] > mymaxl) mymaxl = mymaxlflag[2] ;

    mymaxl = maxl ;
    // This line could be commented out for greater efficiency, but 
    // it doesn't affect the size of the final representation.


  //------------------------------------------------------------------------
  // At this point we have the lighting and BRDF coefficients.
  // The following calculations are done in real form, which is simpler
  // to implement.  The paper gives the complex forms which are easier to
  // reason with.  
  //------------------------------------------------------------------------


  for (l = 0 ; l <= mymaxl ; l++)
    for (p = 0 ; p <= maxp ; p++)
      for (q = 0 ; q <= maxp ; q++) { 
	if (q > l || q > p) continue ;
	double val = 1.0 ;
	if (q == 0) val *= sqrt2 ;
	val *= sqrtpi ; // val is multiplicative factor.
    for (m = -l ; m <= l ; m++) {
      for (j = 0 ; j < 3 ; j++) {
	refcoeffs[l][m+maxl][p][q+maxl][j] = 
	  lightcoeffs[j][l][m+maxl]*brdfcoeffs[j][l][p][q]*val ;
	refcoeffs[l][m+maxl][p][-q+maxl][j] = 
	  lightcoeffs[j][l][m+maxl]*brdfcoeffs[j][l][p][q]*val ;
      }
    }
      }

  gettimeofday(&tv,&tz) ;
  fprintf(stderr,"Checkpoint5: B coeffs: %ld %ld\n", tv.tv_sec, tv.tv_usec) ;

  //-----------------------------------------------------------------------
  // At this point we have the reflected light field coefficients.
  // It is now time to create the reflectionmap
  //-----------------------------------------------------------------------

  createreflectionmap(refcoeffs,refmap) ;

  fprintf(stderr,"Created Reflection Map\n") ;

  gettimeofday(&tv,&tz) ;
  fprintf(stderr,"Checkpoint6: Reflection Map: %ld %ld\n", tv.tv_sec, tv.tv_usec) ;

  //----------------------------------------------------------------------
  // Now have reflection map; need to warp into local coordinates (local SHRM)
  //----------------------------------------------------------------------

  warpreflectionmap(refmap,refwarp,kautzrefwarp) ;

  fprintf(stderr,"Warped Reflection Map\n") ;

  gettimeofday(&tv,&tz) ;
  fprintf(stderr,"Checkpoint6: Warp: %ld %ld\n", tv.tv_sec, tv.tv_usec) ;

  char cmdline[300] ; cmdline[0] = 0 ;
  char maxpval[300] ; sprintf(maxpval,"maxp = %d",mymaxp) ;
  for (i = 0 ; i < argc ; i++) {
    strcat(cmdline,argv[i]) ; strcat(cmdline," ") ;
  }
  strcat(cmdline,maxpval) ;

  printshrms(argv[2],cmdline) ; // Print final SHRM
  
  gettimeofday(&tv,&tz) ;
  fprintf(stderr,"Checkpoint7: All Done: %ld %ld\n", tv.tv_sec, tv.tv_usec) ;
}
