/****************************************************************************

Numerical constants and function definitions relevant for the main numerical
code in the program.  The values of maxl, maxtheta, and maxphi may be 
changed for greater accuracy.

Ravi Ramamoorthi: May 22, 2002

***************************************************************************/


#ifdef LEGENDRE
#define EXTERN
#else
#define EXTERN extern
#endif 

const int maxl = 20 ; // Maximum l value.  Can be changed for greater accuracy.
const int maxtheta = 100 ; // Grid size in theta
const int maxphi = 100 ; // Grid size in phi
EXTERN int simpsonflag  ;
EXTERN double theta[maxtheta] ;
EXTERN double costheta[maxtheta] ;
EXTERN double sintheta[maxtheta] ;
EXTERN double sintheta2[maxtheta] ;
EXTERN double sinthetafull[maxtheta] ;
EXTERN complex<double> expphi[maxphi] ;
EXTERN complex<double> expphim[maxphi][2*maxl+1] ;
EXTERN double cosphi[maxphi] ;
EXTERN double sinphi[maxphi] ;
EXTERN double phi[maxphi] ;
EXTERN double plm[maxl+1][maxl+1][maxtheta] ;
EXTERN double Rlm[maxl+1][maxl+1][maxtheta] ;
//EXTERN complex<double> G[maxl+1][maxl+1][2*maxl+1] ;
EXTERN double D[maxl+1][2*maxl+1][2*maxl+1][maxtheta] ;
EXTERN  double T[maxl+1][maxl+1][maxl+1] ;
EXTERN double P[maxl+1][maxtheta] ;

const double legcoeffs[]=
{0.886227,1.02333,0.495416,0,-0.110778,0,0.0499271,0,-0.0285469,0,0.0185081,
 0,-0.0129818,0,0.00961254,0,-0.00740571,0,0.00588128,0,-0.00478398} ;

const double uhemcoeffs[] = 
{0.707107, 0.612372, 0., -0.233854, 0., 0.146575, 0., -0.106977, 0., \
0.0842791, 0., -0.0695454, 0., 0.059204, 0., -0.0515434, 0., 0.0456399, 0., \
-0.0409508, 0., 0.037136, 0., -0.0339718, 0., 0.0313046, 0., -0.029026, 0., \
0.0270566, 0., -0.0253376, 0., 0.0238241, 0., -0.0224812, 0., 0.0212817, 0., \
 -0.0202037, 0.} ;

double fact(double m) ;
unsigned long comb(unsigned long n, unsigned long m) ;
double plmval(int l, int m, int i) ;
double plmval(int l, int m, double i) ;
double plmvalreal(int l, int m, int i) ;
double plmvalreal(int l, int m, double i) ;
void setuplegendre(void) ;
complex<double> Y(int l, int m, int i, int j) ;
complex<double> Y(int l, int m, double i, double j) ;
complex<double> Ystar(int l, int m, int i, int j) ;
complex<double> Ystar(int l, int m, double i, double j) ;
double Yreal(int l, int m, int i, int j) ;
double Yreal(int l, int m, double i, double j) ;
double Yrealiso(int l, int r, int s, int phi, int thetain, int thetaout) ;
double Yrealiso(int l, int r, int s, double phi, double thetain, double thetaout) ;
void printvals(int l, int m, int i, int j) ;
double expreal(int m, int j) ;
double expreal(int m, double j) ;
complex<double> expcomplex(int m, double j) ;

double Rlmval(int l, int m, int i) ;
double Rlmval(int l, int m, double i) ;
double Rlmvalreal(int l, int m, int i) ;
double Rlmvalreal(int l, int m, double i) ;
complex<double> Z(int l, int m, int i, int j) ;
complex<double> Z(int l, int m, double i, double j) ;
complex<double> Zstar(int l, int m, int i, int j) ;
complex<double> Zstar(int l, int m, double i, double j) ;
double Zreal(int l, int m, int i, int j) ;
double Zreal(int l, int m, double i, double j) ;
double Zrealiso(int l, int r, int s, int phi, int thetain, int thetaout) ;
double Zrealiso(int l, int r, int s, double phi, double thetain, double thetaout) ;
void printvalsZ(int l, int m, int i, int j) ;
