/****************************************************************************

The main code to create and output spherical harmonics.  This is the numerical
heart of the program.  For the most part, this is uncommented, although 
the code is relatively simple.  setuplegendre preprocesses setting up all 
the functions.  Of course, there exist better commercially available
numerical packages.  There's also a lot of stuff here that's generally 
useful, but isn't essential to this particular program.

Ravi Ramamoorthi: May 22, 2002

***************************************************************************/

#include <iostream.h>
#include <complex>
#include <math.h>
#include <assert.h>
#define LEGENDRE
#include "legendre.h"

const double rt2 = 1.4142136 ;

double fact(double m) {
  // Computes sqrt[2m!/(2^m m!)^2] 
  double retval = sqrt((2*m+1)/(4*M_PI)) ;
  for (int i = 1 ; i <= 2*m-1 ; i+=2)
    retval *= -sqrt((double) i/(double) (i+1)) ;
  return retval ;
}

unsigned long comb(unsigned long n, unsigned long m) {
  assert(n >= 0 && m >= 0 && n >= m) ;
  if (m > n/2) m = n-m ;
  unsigned long num = 1,den = 1 ;
  int i ;
  for (i = 1 ; i <= m ; i++) {
    num *= n-i+1 ;
    den *= i ;
  }
  return num/den ;
}

void setuplegendre(void) {
  int i,j,p,q,k,l,m,n,s ;
  for (i = 0 ; i < maxtheta ; i++) {
    theta[i] = M_PI*i/maxtheta ;
    costheta[i] = cos(theta[i]) ;
    sintheta[i] = sin(theta[i]) ;
    sinthetafull[i] = sin(theta[i]/2.0) ;
    sintheta2[i] = sin(theta[i]/4.0) ;
  }
  for (i = 0 ; i < maxphi ; i++) {
    phi[i] = 2.0*M_PI*i/(maxphi) ;
    cosphi[i] = cos(phi[i]) ;
    sinphi[i] = sin(phi[i]) ;
    complex<double> z(cosphi[i],sinphi[i]) ;
    expphi[i] = z ;
    for (l = -maxl ; l <= maxl ; l++) 
      expphim[i][l+maxl] = complex<double>(cos(l*phi[i]),sin(l*phi[i])) ;
  }
  for (m = 0 ; m <= maxl ; m++) {
    double fac = fact(m) ;
    for (i = 0 ; i < maxtheta ; i++) {
      plm[m][m][i] = fac*pow(sintheta[i],m) ;
      if (m < maxl) plm[m+1][m][i] = sqrt(2*m+3)/(2*m+1)*costheta[i]*(2*m+1)*plm[m][m][i] ;
    }
    for (l = m+2 ; l <= maxl ; l++) {
      for (i = 0 ; i < maxtheta ; i++) {
	double v1 = sqrt((2*l+1.0)*(2*l-1.0)*(l-m)/((double)(l+m))) * costheta[i] ;
	double v2 = sqrt((2*l+1.0)/(2*l-3.0)*(l-m)/((double) (l+m))*(l-m-1.0)*(l+m-1.0)) ;
	plm[l][m][i] =  (v1*plm[l-1][m][i]-v2*plm[l-2][m][i])/(l-m) ;
      }
    }
  }
  // Zernike Polynomials
  for (n = 0 ; n <= maxl ; n++) {
    for (m = 0 ; m <= n ; m++) {
      if (((n-m)%2) != 0) continue ;
      for (s = 0 ; s <= (n-m)/2 ; s++) {
	k = n/2 ;
	if (m == 0 || m == 1) {
	  T[n][m][s] = pow(-1,s)*comb(n-s,k)*comb(k,s) ;
	}
	else {
	  double vd = (n-m)/2.0 ;
	  double vs = (n+m)/2.0 ;
	  T[n][m][s] = T[n][m-2][s]*(vd+1-s)/(vs-s) ;
	}
      }
    }
  }
  for (i = 0 ; i < maxtheta ; i++) {
    double pw = rt2*sintheta2[i] ;
    double tm = 1 ;
      for (n = 0 ; n <= maxl ; n++) {
	P[n][i] = tm ;
	tm *= pw ;
      }
  }
  for (n = 0 ; n <= maxl ; n++) {
    for (m = 0 ; m <= n ; m++) {
      if (((n-m)%2) != 0) continue ;
      for (i = 0 ; i < maxtheta ; i++) {
	Rlm[n][m][i] = 0 ;
	for (s = 0 ; s <= (n-m)/2 ; s++) {
	  Rlm[n][m][i] += T[n][m][s]*P[n-2*s][i]*sqrt((n+1)/(2.0*M_PI)) ;
	}
      }
    }
  }
}

complex<double> Y(int l, int m, int i, int j) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  complex<double> t(plm[l][mindex][i]) ;
  t *=  expphim[j][m+maxl] ; // pow(expphi[j],m) ;
  if (m > 0) return t ;
  else {
    int sgn ;
    if (m % 2 == 0) sgn = 1 ; else sgn = -1 ;
    return sgn*t ;
  }
}

double Yreal(int l, int m, int i, int j) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  double t =  plm[l][mindex][i] ;
  if (m == 0) return t ;
  t *= rt2 ;
  if (m > 0) t *= expphim[j][mindex+maxl].real() ;
  else t *= expphim[j][mindex+maxl].imag() ;
  return t ;
}

double Yrealiso(int l, int r, int s, int phi, int thetain, int thetaout) {
  assert(s>=0&&s<=maxl&&l>=s&&l<=maxl&&r>=s&&r<=maxl) ;
  assert(!((r+s)%2==0||(l+s)%2==0)) ;
  double v1 = Yreal(l,s,thetain,0)*Yreal(r,s,thetaout,phi) ;
  if (s == 0) return v1 ;
  double v2 = Yreal(l,-s,thetain,0)*Yreal(r,-s,thetaout,phi) ;
  return v1+v2 ;
}

complex<double> Y(int l, int m, double i, double j) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l) ;
  complex<double> t(plmval(l,m,i)) ;
  t *= expcomplex(m,j) ;
  return t ;
}

double Yreal(int l, int m, double i, double j) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l) ;
  double t = plmvalreal(l,m,i) ;
  t *= expreal(m,j) ;
  return t ;
}

double Yrealiso(int l, int r, int s, double phi, double thetain, double thetaout) {
  assert(s>=0&&s<=maxl&&l>=s&&l<=maxl&&r>=s&&r<=maxl) ;
  assert(!((r+s)%2==0||(l+s)%2==0)) ;
  double v1 = Yreal(l,s,thetain,0.0)*Yreal(r,s,thetaout,phi) ;
  if (s == 0) return v1 ;
  double v2 = Yreal(l,-s,thetain,0.0)*Yreal(r,-s,thetaout,phi) ;
  return v1+v2 ;
}

complex<double> Ystar(int l, int m, int i, int j) {
  complex<double> t = Y(l,m,i,j) ;
  return complex<double>(t.real(),-t.imag()) ;
}

complex<double> Ystar(int l, int m, double i, double j) {
  complex<double> t = Y(l,m,i,j) ;
  return complex<double>(t.real(),-t.imag()) ;
}

double plmval(int l, int m, int i) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  double t = plm[l][mindex][i] ;
  if (m > 0) return t ;
  else {
    int sgn ;
    if (m % 2 == 0) sgn = 1 ; else sgn = -1 ;
    return sgn*t ;
  }
}

double plmval(int l, int m, double i) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  int iint = (int) i ;
  double fraci = i - iint ;
  double t ;
  assert(i >= 0 && i <= maxtheta - 1) ;
  if (fabs(fraci)<1.0e-4) t = plm[l][mindex][iint] ;
  else {
    t = fraci*plm[l][mindex][iint+1]+(1-fraci)*plm[l][mindex][iint] ;
  }
  if (m > 0) return t ;
  else {
    int sgn ;
    if (m % 2 == 0) sgn = 1 ; else sgn = -1 ;
    return sgn*t ;
  }
}

double plmvalreal(int l, int m, int i) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  double t = plm[l][mindex][i] ;
  if (m != 0) t *= rt2 ;
  return t ;
}

double plmvalreal(int l, int m, double i) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  int iint = (int) i ;
  double fraci = i - iint ;
  double t ;
  assert(i >= 0 && i <= maxtheta - 1) ;
  if (fabs(fraci)<1.0e-4) t = plm[l][mindex][iint] ;
  else {
    t = fraci*plm[l][mindex][iint+1]+(1-fraci)*plm[l][mindex][iint] ;
  }
  if (m != 0) t *= rt2 ;
  return t ;
}


complex<double> Z(int l, int m, int i, int j) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l && ((l+m)%2)==0) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  complex<double> t(Rlm[l][mindex][i]) ;
  t *=  expphim[j][m+maxl] ; // pow(expphi[j],m) ;
  return t ;
}

double Zreal(int l, int m, int i, int j) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l &&((l+m)%2)==0) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  double t =  Rlm[l][mindex][i] ;
  if (m == 0) return t ;
  t *= rt2 ;
  if (m > 0) t *= expphim[j][mindex+maxl].real() ;
  else t *= expphim[j][mindex+maxl].imag() ;
  return t ;
}

double Zrealiso(int l, int r, int s, int phi, int thetain, int thetaout) {
  assert(s>=0&&s<=maxl&&l>=s&&l<=maxl&&r>=s&&r<=maxl) ;
  assert(((r+s)%2==0)&&((l+s)%2==0)) ;
  double v1 = Zreal(l,s,thetain,0)*Zreal(r,s,thetaout,phi) ;
  if (s == 0) return v1 ;
  double v2 = Zreal(l,-s,thetain,0)*Zreal(r,-s,thetaout,phi) ;
  return v1+v2 ;
}

complex<double> Z(int l, int m, double i, double j) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l && ((l+m)%2)==0) ;
  complex<double> t(Rlmval(l,m,i)) ;
  t *= expcomplex(m,j) ;
  return t ;
}

double Zreal(int l, int m, double i, double j) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l && ((l+m)%2)==0) ;
  double t = Rlmvalreal(l,m,i) ;
  t *= expreal(m,j) ;
  return t ;
}

double Zrealiso(int l, int r, int s, double phi, double thetain, double thetaout) {
  assert(s>=0&&s<=maxl&&l>=s&&l<=maxl&&r>=s&&r<=maxl) ;
  assert(((r+s)%2==0)&&((l+s)%2==0)) ;
  double v1 = Zreal(l,s,thetain,0.0)*Zreal(r,s,thetaout,phi) ;
  if (s == 0) return v1 ;
  double v2 = Zreal(l,-s,thetain,0.0)*Zreal(r,-s,thetaout,phi) ;
  return v1+v2 ;
}

complex<double> Zstar(int l, int m, int i, int j) {
  complex<double> t = Z(l,m,i,j) ;
  return complex<double>(t.real(),-t.imag()) ;
}

complex<double> Zstar(int l, int m, double i, double j) {
  complex<double> t = Z(l,m,i,j) ;
  return complex<double>(t.real(),-t.imag()) ;
}

double Rlmval(int l, int m, int i) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l && ((l+m)%2==0)) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  double t = Rlm[l][mindex][i] ;
  return t ;
}

double Rlmval(int l, int m, double i) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l && ((l+m)%2==0)) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  int iint = (int) i ;
  double fraci = i - iint ;
  double t ;
  assert(i >= 0 && i <= maxtheta - 1) ;
  if (fabs(fraci)<1.0e-4) t = Rlm[l][mindex][iint] ;
  else {
    t = fraci*Rlm[l][mindex][iint+1]+(1-fraci)*Rlm[l][mindex][iint] ;
  }
  return t ;
}


double expreal(int m, int j) {
  if (m >= 0) return expphim[j][m+maxl].real() ;
  else return expphim[j][-m+maxl].imag() ;
}

double expreal(int m, double j) {
  int iint = (int) j ;
  double fraci = j - iint ;
  double t ;
  assert(j >= 0 && j <= maxphi - 1) ;
  if (fabs(fraci)<1.0e-4) {
    if (m >= 0) t = expphim[iint][m+maxl].real() ;
    else t = expphim[iint][-m+maxl].imag() ;
  }
  else {
    if (m >= 0) t = (1-fraci)*expphim[iint][m+maxl].real()
		  +    fraci *expphim[iint+1][m+maxl].real() ;
    else t = (1-fraci)*expphim[iint][-m+maxl].imag()
		  +    fraci *expphim[iint+1][-m+maxl].imag() ;
  }
  return t ;
}

complex<double> expcomplex(int m, double j) {
  int iint = (int) j ;
  double fraci = j - iint ;
  complex<double> t ;
  assert(j >= 0 && j <= maxphi - 1) ;
  if (fabs(fraci) < 1.0e-4) t = expphim[iint][m+maxl] ;
  else t = (1-fraci)*expphim[iint][m+maxl]+fraci*expphim[iint+1][m+maxl] ;
  return t ;
}

double Rlmvalreal(int l, int m, int i) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l && ((m+l)%2==0)) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  double t = Rlm[l][mindex][i] ;
  if (m != 0) t *= rt2 ;
  return t ;
}

double Rlmvalreal(int l, int m, double i) {
  assert(l>=0 && l <= maxl && m >= -l && m <= l && ((m+l)%2==0)) ;
  int mindex = m ; if (m < 0) mindex *= -1 ;
  int iint = (int) i ;
  double fraci = i - iint ;
  double t ;
  assert(i >= 0 && i <= maxtheta - 1) ;
  if (fabs(fraci)<1.0e-4) t = Rlm[l][mindex][iint] ;
  else {
    t = fraci*Rlm[l][mindex][iint+1]+(1-fraci)*Rlm[l][mindex][iint] ;
  }
  if (m != 0) t *= rt2 ;
  return t ;
}

void printvals(int l, int m, int i, int j) {
  cout << " l = " << l << " m = " << m << " i = " << i << " j = " << j << " Val = " << Y(l,m,i,j) << "\n" ; 
}

void printvalsZ(int l, int m, int i, int j) {
  cout << " l = " << l << " m = " << m << " i = " << i << " j = " << j << " Val = " << Z(l,m,i,j) << "\n" ; 
}

