/*  This is the code for creating the appropriate reflection map.
    Inputs should be a tabulated form of the BRDF and the
    illumination.  Output should be a reflection map. */

#include <iostream.h>
#include <iomanip.h>
#include <complex>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include "legendre.h"
#include <time.h>
#include <fstream.h>
#include <sys/time.h>
#include <unistd.h>

  const int numsamps = 61 ;
  const double sqrt2 = sqrt(2.0) ;
  const double sqrtpi = sqrt(M_PI) ;

// This code is pretty spuddish; I'd like to write a better version
// sometime later, but for now...

// These are utility functions and variables.
//--------------------------------------------------------------------------

double brdf[3][maxtheta][maxtheta][maxphi] ;
double brdftest[3][maxtheta][maxtheta][maxphi] ;

double lightcoeffs[maxl+1][2*maxl+1][3] ;
double brdfcoeffs[3][maxl+1][maxl+1][maxl+1] ;
double refcoeffs[maxl+1][2*maxl+1][maxl+1][2*maxl+1][3] ;
double zercoeffs[1+numsamps][maxl+1][maxl+1][maxl+1][3] ;
float zvals[maxtheta][maxtheta][maxphi][55] ;

bool valbrdf[maxtheta][maxtheta][maxphi] ;

const int zmaxl = 8 ;
const int maxp = 10 ;
int mymaxl = maxl ;
int mymaxp = maxp ;
const int maxv = 10 ;

double refmap[maxtheta][maxphi][maxp+1][2*maxp+1][3] ;
double refwarp[maxtheta][maxphi][maxp+1][2*maxp+1][3] ;
double imagelist[maxv][maxv][maxtheta][maxphi][3] ;
double imagetmp[maxv][maxtheta][maxphi][2*maxp+1][3] ;

// Used for reflectionmap.  Globals here to force them to 0.

double costmp[maxtheta][maxl+1][maxp+1][2*maxp+1][3] ;
double sintmp[maxtheta][maxl+1][maxp+1][2*maxp+1][3] ;

double rz[maxtheta][maxphi][maxp+1][2*maxp+1][3] ;

double mulfac = 1.0 ;

//--------------------------------------------------------------------------
// Krylon stuff
//--------------------------------------------------------------------------

const int width = 256 ;
unsigned char krylonp[width][width][3] ;
unsigned char krylonq[width][width][3] ;
//double mult[3] = {11.4187,0.0555595,0.0841939} ;
//double mult[3] = {0.043248,0.0725744,0.0527886} ;
double mult[3] = {0.0304027,0.000378451,1.46881e-06} ;
double light[3] = {.866,0,0.5} ;
//double light[3] = {0,0,1} ;

//--------------------------------------------------------------------------

double dotp(double v1[3], double v2[3]) {
  return v1[0]*v2[0]+v1[1]*v2[1]+v1[2]*v2[2] ;
}

void findangles(double posn[3], double &theta, double &phi) {
  theta = acos(posn[2]) ;
  phi = atan2(posn[1],posn[0]) ;
  if (phi < 0) phi += 2.0*M_PI ;
}

void  reflectionvector(double surf[3], double camloc[3], double refvec[3]) {
  int i ;
  double d ;
  d = dotp(surf,camloc) ;
  for (i = 0 ; i < 3 ; i++)
    refvec[i] = 2*d*surf[i]-camloc[i] ;
  if (fabs(refvec[2])>1.0) refvec[2] *= .999 ;
  //  return d ;
}

void project(double vec[3], double &u, double &v) {
  double pv, ar, x, y, z ;
  x = vec[0] ; y = vec[1] ; z = vec[2] ;
  pv = 7.0/8.0 ;
  ar = 1.0/(2.0*(1.0+z)) ;
  u  = pv*x*ar + 0.5 ;
  v  = pv*y*ar + 0.5 ;
  u *= width ;
  v = width*(1.0-v) ;
}

/*
void cosineseries(double fit[maxphi], double fitcoeffs[maxl+1]) {
  int i,j ;
  for (i = 0 ; i <= maxl ; i++) {
    double sum = 0 ;
    for (j = 0 ; j < maxphi ; j++) {
      sum += fit[j]*cosphi[(i*j)%maxphi]*M_PI/maxphi ;
    }
    fitcoeffs[i] = 2.0*M_PI*sum ;
  }
}
*/

int cosineseries(double fit[maxphi], double fitcoeffs[maxl+1]) {
  int i,j ;
  int ctr ;
  for (i = 0 ; i <= mymaxp ; i++) {  // Changed from maxl -- Ravi.
    double sum = 0 ;
    ctr = 0 ;
    for (j = 0 ; j < maxphi ; j++) {
      if (1 /* valid[j] */) {
	  sum += fit[j]*cosphi[(i*j)%maxphi]*sqrtpi/maxphi ;
	  ++ctr ; 
	}
    }
    if (ctr != 0) fitcoeffs[i] = 2.0*M_PI*sum*maxphi/ctr ;
    else fitcoeffs[i] = 0 ;
  }
  return ctr ;
}

void cosineunroll(double fitcoeffs[maxl+1], double fit[maxphi]) {
  int i,j ;
  for (i = 0 ; i < maxphi ; i++) {
    double sum = 0 ;
    for (j = 0 ; j <= mymaxl ; j++) {
      sum += fitcoeffs[j]*cosphi[(i*j)%maxphi] ;
    }
    fit[i] = sum ;
  }
}

void findcoeffs(double fit[maxtheta][maxtheta][maxphi], double fitcoeffs[maxl+1][maxl+1][maxl+1]) {
  double tmp1[maxtheta][maxtheta][maxl+1] ;
  int count1[maxtheta][maxtheta] ;
  double tmp2[maxtheta][maxl+1][maxl+1] ;
  int count2[maxtheta] ;
  int i,j,k,l ;
  for (i = 0 ; i < maxtheta ; i++)
    for (j = 0 ; j < maxtheta ; j++)
      count1[i][j] = cosineseries(fit[i][j],tmp1[i][j]) ;

    for (k = 0 ; k <= mymaxp ; k++) {
      for (j = k ; j <= mymaxp ; j++) {
	for (i = 0 ; i < maxtheta ; i++) {
	  double sum = 0 ;
	  int ctr1 = 0 ; 
	  for (l = 0 ; l < maxtheta ; l++) {
	    sum += sintheta[l]*M_PI*tmp1[i][l][k]*plmvalreal(j,k,l)*count1[i][l] ;
	    ctr1 += count1[i][l] ;
	  }
	  if (ctr1 == 0) tmp2[i][j][k] = 0 ;
	  else tmp2[i][j][k] = sum/ctr1 ;
	  count2[i] = ctr1 ;
	}
      }
    }

    for (k = 0 ; k <= mymaxp ; k++) {
      for (j = k ; j <= mymaxp ; j++) {
	for (i = k ; i <= maxl ; i++) {
	  double sum = 0 ;
	  int ctr = 0 ;
	  for (l = 0 ; l < maxtheta ; l++) {
	    sum += sintheta[l]*M_PI*tmp2[l][j][k]*plmvalreal(i,k,l)*count2[l] ;
	    ctr += count2[l] ;
	  }
	  assert(ctr) ;
	  if (k == 0) fitcoeffs[i][j][k] = sqrt(2)*sum/ctr ;
	  else fitcoeffs[i][j][k] = sum/ctr ;
	}
      }
    }
}

void unrollcoeffs(double fitcoeffs[maxl+1][maxl+1][maxl+1], double fit[maxtheta][maxtheta][maxphi]) {
  double tmp1[maxtheta][maxl+1][maxl+1] ;
  double tmp2[maxtheta][maxtheta][maxl+1] ;
  int l,p,q,i,j;

  for (q = 0 ; q <= mymaxp ; q++)
    for (p = q ; p <= mymaxp ; p++)
      for (i = 0 ; i < maxtheta ; i++) {
	double sum = 0 ;
	for (l = q ; l <= mymaxl ; l++) {
	  sum += sqrtpi*plmvalreal(l,q,i)*fitcoeffs[l][p][q] ;
	}
	tmp1[i][p][q] = sum ;
      }

  for (q = 0 ; q <= mymaxp ; q++)
    for (i = 0 ; i < maxtheta ; i++)
      for (j = 0 ; j < maxtheta ; j++) {
	double sum = 0 ;
	for (p = q ; p <= mymaxp ; p++) {
	  sum += plmvalreal(p,q,j)*tmp1[i][p][q] ;
	}
	if (q == 0) tmp2[i][j][q] = sqrt2*sum ;
	else tmp2[i][j][q] = sum ;
      }

  for (i = 0 ; i < maxtheta ; i++)
    for (j = 0 ; j < maxtheta ; j++)
      cosineunroll(tmp2[i][j],fit[i][j]) ;
}

void printcoeffs(double coeffs[maxl+1][maxl+1][maxl+1]) {
  int l,p,q ;
  for (l = 0 ; l <= maxl ; l++)
    for (p = 0 ; p <= maxl ; p++)
      for (q = 0 ; q <= maxl ; q++) {
	if (q > p || q > l) continue ;
	//if ((l+q)%2==0 || (p+q)%2==0) continue;
	//	if (fabs(coeffs[l][p][q])>2.0) 
	  printf("%4d %4d %4d %12.6lf\n",l,p,q,coeffs[l][p][q]) ;
      }
}

void readd(char * filename) {
  FILE * fp ;
  assert(fp = fopen(filename,"rt")) ;
  int l,j,q ;
  int a ;
  int step = 1 ; // 100/maxtheta ;
  for (l = 0 ; l <= ((maxl >= 20) ? 20: maxl) ; l++)
    for (a = 0 ; a < 100 ; a++) {
      int tmp1, tmp2 ;
      fscanf(fp,"%d %d",&tmp1,&tmp2) ;
      assert(tmp1 == l) ; assert(tmp2 == a) ;
      for (j = -l ; j <= l ; j++)
	for (q = -l ; q <= l ; q++) {
	  double tmp ;
	  fscanf(fp,"%lf ",&tmp) ;
	  if (a%step==0) {
	    D[l][maxl+j][maxl+q][a/step] = tmp ;
	    // D[l][maxl+j][maxl+q][a/step] *= sqrt((2*l+1)/(4*M_PI)) ;
	  }
	}
    }
}

/*
double Dval(int l, int m, int q, double theta) {
  double aval = theta/M_PI*100.0 ;
  if (aval > 99) aval = 98.9999 ;
  int aint ; double afrac ;
  aint = (int) aval ;
  afrac = aval - aint ;
  assert(aint >= 0 && aint < 99) ;
  return (1-afrac)*D[l][m+maxl][q+maxl][aint]+afrac*D[l][m+maxl][q+maxl][1+aint] ;
}
*/

/*
double Dval(int l, int m, int q, int theta) {
  int divfac ;
  assert(maxtheta == 200) ;
  assert (theta >= 0 && theta <= maxtheta-1) ;
  if (l > 20) return 0 ;
  if (theta % 2 == 0) return D[l][maxl+m][maxl+q][theta/2] ;
  else return (D[l][maxl+m][maxl+q][theta/2] + D[l][maxl+m][maxl+q][1+theta/2])/2.0 ;
}
*/

double Dval(int l, int m, int q, int theta) {
  int divfac ;
  if (l > 20) return 0 ;
  double mytheta = theta *100.0/maxtheta ;
  if (mytheta > 99.0) mytheta = maxtheta - 98.999 ;
  assert(mytheta >= 0 && mytheta < 99) ;
  int myt = (int) mytheta ;
  double frac = mytheta - myt ;

  double val = (1-frac)*D[l][m+maxl][q+maxl][myt] + 
                  frac *D[l][m+maxl][q+maxl][myt+1] ;
  return val ;
}


void createreflectionmap (
 double refcoeffs[maxl+1][2*maxl+1][maxl+1][2*maxl+1][3], 
 double refmap[maxtheta][maxphi][maxp+1][2*maxp+1][3] ) 
{
  const double rt2 = sqrt(2.0) ;
  int l,m,p,q,j,th,ph ;

  // Expand over index l

  for (th = 0 ; th < maxtheta ; th++) {
    for (l = 0 ; l <= mymaxl ; l++) {
      double lmul = sqrt(4.0*M_PI/(2.0*l+1)) ;
      for (m = -l ; m <= l ; m++)
	for (p = 0 ; p <= mymaxp ; p++)
	  for (q = -p ; q <= p ; q++) {
	    if (fabs(q)>l) continue ;
	    int mindex = m ;
	    if (m < 0) mindex *= -1 ;
	    int sgnflag ;
	    if (m < 0) sgnflag = -1 ;
	    else sgnflag = 1 ;
	    
	    double basisfn1, basisfn2 ;
	    
	    /*
	    if (q == 0) { 
	      double v = lmul*plm[l][mindex][th] ;
	      if (m > 0) { basisfn1 = v*rt2 ; basisfn2 = 0 ; }
	      else if (m < 0) { basisfn2 = v*rt2 ; basisfn1 = 0 ; }
	      else { assert(m==0) ; basisfn1 = v ; basisfn2 = 0 ; }
	    }
	    */
	    //	    else {
	      basisfn1 =  Dval(l, m,q,th) ;
	      basisfn2 = -sgnflag*Dval(l,-m,q,th) ;
	      //}
	    for (j = 0 ; j < 3 ; j++) {
	      costmp[th][mindex][p][q+maxp][j] += 
		basisfn1*refcoeffs[l][m+maxl][p][q+maxl][j] ;
	      sintmp[th][mindex][p][q+maxp][j] += 
		basisfn2*refcoeffs[l][m+maxl][p][q+maxl][j] ;
	    }
	  }
    }
  }

  // Expand over index m

  for (th = 0 ; th < maxtheta ; th++)
    for (ph = 0 ; ph < maxphi ; ph++)
      for (m = 0 ; m <= mymaxl ; m++) {
	int bb = (m*ph)%maxphi ;
	for (p = 0 ; p <= mymaxp ; p++)
	  for (q = -p ; q <= p ; q++) 
	    for (j = 0 ; j < 3 ; j++) {
	      refmap[th][ph][p][q+maxp][j] += 
		 costmp[th][m][p][q+maxp][j]*cosphi[bb]+
                 sintmp[th][m][p][q+maxp][j]*sinphi[bb] ;
	    }
      }

  // Checking routines...
  int a,b,to,po,col ;

  a = 17 ; b = 23 ; to = 42 ; po = 21 ; col = 0 ;
  double val1 = 0 ;
  for (p = 0 ; p <= mymaxp ; p++)
    for (q = -p ; q <= p ; q++) {
      val1 += Yreal(p,q,to,po)*refmap[a][b][p][q+maxp][col] ;
    }

  double val2 = 0 ;
  for (l = 0 ; l <= mymaxl ; l++)
    for (m = -l ; m <= l ; m++)
      for (p = 0 ; p <= mymaxp ; p++)
	for (q = -p ; q <= p ; q++) {

	  int mindex = m ;
	  if (m < 0) mindex *= -1 ;
	  int sgnflag ;
	  if (m < 0) sgnflag = -1 ;
	  else sgnflag = 1 ;

	  int bb = ((int) (mindex*b))%maxphi ;
	  
	  double basisfn ;
	  /*	  if (q == 0)  basisfn = Yreal(p,q,to,po)*Yreal(l,m,a,b)*sqrt(4.0*M_PI/(2.0*l+1));*/
	  //	  else 
	    basisfn = Yreal(p,q,to,po)*(Dval(l,m,q,a)*cosphi[bb] - sgnflag*Dval(l,-m,q,a)*sinphi[bb]) ;

	  val2 += refcoeffs[l][m+maxl][p][q+maxl][col]*basisfn ;	  
	}
  printf("%d %d %d %d %d || V1: %lf V2: %lf\n",a,b,to,po,col, val1,val2) ;
}

void warpreflectionmap(double refmap[maxtheta][maxphi][maxp+1][2*maxp+1][3], double refwarp[maxtheta][maxphi][maxp+1][2*maxp+1][3])
{
  int l,m,a,b,p,q,j,col ;

  for (a = 0 ; a < maxtheta ; a++) 
    for (b = 0 ; b < maxphi ; b++)
      for (p = 0 ; p <= mymaxp ; p++)
	for (q = -p ; q <= p; q++)
	  for (m=-p ; m <= p; m++)
	  for (j = 0 ; j < 3; j++)
	  {
	  int qindex = (q >= 0) ? q : -q ;
	  int mindex = (m >= 0) ? m : -m ;
	  double sgnflag = pow(-1,qindex) * pow(-1,mindex) ;
	  double sgnflag2 ;
	  if (q < 0) sgnflag2 = -1 ; else sgnflag2 = 1 ;
	  int bb = (qindex*b)%maxphi ;

	  double t = sgnflag*refmap[a][b][p][m+maxp][j]*Dval(p,m,q,a) ;
	  

	  refwarp[a][b][p][ q+maxp][j] += t*cosphi[bb] ;
	  refwarp[a][b][p][-q+maxp][j] += t*sinphi[bb]*sgnflag2 ;	    
	  }

  double th,ph,to,po ;
	   	  
  // Checking routines:
  a = 17 ; b = 23 ; to = 17 ; po = maxphi/2 ; col = 0 ; th = 0 ; ph = 0 ;
  double val1 = 0 ; 
  for (p = 0 ; p <= mymaxp ; p++)
    for (q = -p ; q <= p ;q++) {
      
      //      printf("%d %d refmap %lf rz %lf refwarp %lf val1 %lf val2 %lf\n",p,q,              refmap[a][b][p][q+maxp][col], rz[a][b][p][q+maxp][col],                        refwarp[a][b][p][q+maxp][col],                                        	  refmap[a][b][p][q+maxp][col]*Yreal(p,q,to,po),                                 refwarp[a][b][p][q+maxp][col] * Yreal(p,q,th,ph) ) ;
           
      val1 += refmap[a][b][p][q+maxp][col]  * Yreal(p,q,to,po) ;
    }
  double val2 = 0 ;
  for (p = 0 ; p <= mymaxp ; p++)
    for (q = -p ; q <= p ;q++) 
      val2 += refwarp[a][b][p][q+maxp][col] * Yreal(p,q,th,ph) ;
  
  printf("%d %d %d %d %d || V1: %lf V2: %lf\n",a,b,(int)to,(int)po,col, val1,val2) ;
}

void dumpimageref (double refwarp[maxtheta][maxphi][maxp+1][2*maxp+1][3], double view[3]) {
  double thetaview, phiview, th, ph ;
  if (fabs(view[2]) > 1.0) view[2] *= .999 ;
  assert(fabs(view[2] <= 1.0)) ;
  thetaview = acos(view[2]) ;
  phiview = atan2(view[1],view[0]) ;
  if (phiview < 0) phiview += 2.0*M_PI ;
  
  th = thetaview/M_PI*maxtheta ; if (th > maxtheta - 1) th = maxtheta - 1.0001 ;
  ph = phiview/(2.0*M_PI)*maxphi ; if (ph > maxphi - 1) ph = maxphi - 1.0001 ;
  assert(th >= 0 && ph >= 0) ;

  FILE *fp ;
  assert(fp = fopen("tmp.ppm","wb")) ;
  fprintf(fp,"P6\n%d %d\n255\n",maxtheta,maxphi) ;
  int i,j,k,p,q ;
  for (i = 0 ; i < maxtheta ; i++)
    for (j = 0 ; j < maxphi ; j++) 
      for (k = 0 ; k < 3 ; k++) {
	double val = 0 ;
	for (p = 0 ; p <= mymaxp ; p++)
	  for (q = -p ; q <= p ; q++) {
	    val += refwarp[i][j][p][q+maxp][k]*Yreal(p,q,th,ph) ;
	  }
	if (val > 255) val = 255 ;
	if (val < 0) val = 0 ;
	unsigned char c = (unsigned char) val ;
	fprintf(fp,"%c",c) ;
      }
  fclose(fp) ;
}

void dumpimagesphere(double refwarp[maxtheta][maxphi][maxp+1][2*maxp+1][3], double view[3]) {
  int i,j,k,l,p,q ;

  FILE *fp ;
  assert(fp  = fopen("tmp.ppm","wb")) ;
  fprintf(fp,"P6\n%d %d\n255\n",maxtheta,maxphi) ;
  int flag = 0 ;

  for (i = 0 ; i < maxtheta ; i++)
    for (j = 0 ; j < maxtheta ; j++)
      for (k = 0 ; k < 3 ; k++) {

	if (i == 63 && j == 107) {
	  fprintf(stderr,"Here\n") ;
	  //	  flag = 1 ;
	}

	double x,y,z ;
	x = (j-maxtheta/2.0)/(maxtheta/2.0) ;
	y = (maxtheta/2.0-i)/(maxtheta/2.0) ;
	if (x*x + y*y >= 1.0) {
	  unsigned char c = (unsigned char) 0 ;
	  fprintf(fp,"%c",c) ;
	  continue ;
	}
	z = sqrt(1.0-x*x-y*y) ;
	double N[3] ; 
	N[0] = x ; N[1] = y ; N[2] = z ;
	double R[3] ;
	reflectionvector(N,view,R) ;
	double posn[3][3] ;
	posn[2][0] = R[0] ; posn[2][1] = R[1] ; posn[2][2] = R[2] ;
	double alpha, beta ;
	alpha = acos(R[2]) ; beta = atan2(R[1],R[0]) ; 
	if (beta < 0) beta += 2.0*M_PI;
	posn[1][0] = -sin(beta) ; posn[1][1] = cos(beta) ; posn[1][2] = 0 ;
	posn[0][0] = cos(alpha)*cos(beta) ; posn[0][1] = cos(alpha)*sin(beta) ; posn[0][2] = -sin(alpha);
	double lightpos[3], viewpos[3] ;
	for (l = 0 ; l < 3 ; l++) { 
	  viewpos[l]  = dotp(view, posn[l]) ; 
	  lightpos[l] = dotp(light,posn[l]) ;
	}
	
	double thetain, phin, thetaout, phiout, a, b, phi ;
	thetaout= acos(viewpos[2]) ;
	phiout = atan2(viewpos[1],viewpos[0]) ; 
	if (phiout<0) phiout +=2.0*M_PI;
	a = alpha/M_PI*maxtheta ;
	b = beta/(2.0*M_PI)*maxphi ;
	if (a > maxtheta - 1.0) a = maxtheta - 1.0 ;
	if (b > maxphi - 1.0) b = maxphi - 1.0 ;
	assert (a >= 0 && b >= 0) ;
	thetain = acos(lightpos[2]) ;
	phin = atan2(lightpos[1],lightpos[0]) ; if (phin < 0) phin += 2.0*M_PI;
	phi = phiout - phin ; if (phi < 0) phi += 2.0*M_PI ;

        double ti = thetain/M_PI*maxtheta ;
	double phh = phi/(2.0*M_PI)*maxphi;

        double th, ph ;
	th = (thetaout/M_PI*maxtheta) ;
	ph = (phiout/(2.0*M_PI)*maxphi) ; 
	if (th > maxtheta - 1) th = maxtheta - 1.0001 ;
	if (ph > maxphi - 1) ph = maxphi - 1.0001 ;
	assert(th >= 0 && ph >= 0) ;

	double thetaview, phiview, tv, pv ;
	if (fabs(view[2]) > 1.0) view[2] *= .999 ;
	assert(fabs(view[2] <= 1.0)) ;
	thetaview = acos(view[2]) ;
	phiview = atan2(view[1],view[0]) ;
	if (phiview < 0) phiview += 2.0*M_PI ;
  
	tv = thetaview/M_PI*maxtheta ; if (tv > maxtheta - 1) tv = maxtheta - 1.0001 ;
	pv = phiview/(2.0*M_PI)*maxphi ; if (pv > maxphi - 1) pv = maxphi - 1.0001 ;
	assert(tv >= 0 && pv >= 0) ;


	double valtest1, valtest2, valtest3, valtest4 ;
	if (flag) {
	valtest1 = brdf[k][(int) ti][(int) th][(int) phh] ;
	valtest2 = 0 ;

	for (q = 0 ; q <= mymaxp ; q++)
	  for (l = q ; l <= mymaxl ; l++)
	    for (p = q ; p <= mymaxp ; p++) {
	      double mv = 1.0 ;
	      if (q == 0) mv = sqrt2 ;
	      valtest2 += mv*brdfcoeffs[k][l][p][q]*sqrtpi*
		          plmvalreal(l,q,(int)ti)*plmvalreal(p,q,(int)th)
                          *cosphi[(q*(int)phh)%maxphi] ;
	    }

	valtest3 = valtest4 = 0 ;
	int ii,jj,m ;
	for (ii = 0 ; ii < maxtheta ; ii++) 
	  for (jj = 0 ; jj < maxphi ; jj++) {
	    double ltpos[3] ;
	    ltpos[0] = sintheta[ii]*cosphi[jj] ;
	    ltpos[1] = sintheta[ii]*sinphi[jj] ;
	    ltpos[2] = costheta[ii] ;
	    double mf = (2.0*M_PI*M_PI*sintheta[ii])/(maxtheta*maxphi) ;
	    double tin = acos(dotp(ltpos,R)) ;
	    int tinval = (int) (tin/M_PI*maxtheta) ;
	    double lightval = 0 ;
	    for (l = 0 ; l <= mymaxl ; l++)
	      for (m = - l ; m <= l ; m++) 
		lightval += lightcoeffs[l][m+maxl][0]*Yreal(l,m,ii,jj) ;
	    
		valtest3 += mf*brdf[k][tinval][(int) th][(int) phh]*lightval ;
		valtest4 += mf*brdftest[k][tinval][(int) th][(int) phh]*lightval ;
	      
	  }
	}
	

	double val = 0 ;
	for (p = 0 ; p <= mymaxp ; p++)
	  for (q = -p ; q <= p ; q++) {
	    val += refwarp[(int) a][(int) b][p][q+maxp][k]*Yreal(p,q,tv,pv) ;
	  }
	if (val > 255) val = 255 ;
	if (val < 0) val = 0 ;
	unsigned char c = (unsigned char) val ;
	fprintf(fp,"%c",c) ;
      }
  fclose(fp) ;
}

void dumpimage (double refwarp[maxtheta][maxphi][maxp+1][2*maxp+1][3], double view[3]) {
  double thetaview, phiview, th, ph ;
  if (fabs(view[2]) > 1.0) view[2] *= .999 ;
  assert(fabs(view[2] <= 1.0)) ;
  thetaview = acos(view[2]) ;
  phiview = atan2(view[1],view[0]) ;
  if (phiview < 0) phiview += 2.0*M_PI ;
  
  th = thetaview/M_PI*maxtheta ; 
  if (th > maxtheta - 1) th = maxtheta - 1.0001 ;
  ph = phiview/(2.0*M_PI)*maxphi ; if (ph > maxphi - 1) ph = maxphi - 1.0001 ;
  assert(th >= 0 && ph >= 0) ;

  FILE *fp ;
  assert(fp = fopen("tmp.ppm","wb")) ;
  fprintf(fp,"P6\n%d %d\n255\n",maxtheta,maxphi) ;
  int i,j,k,p,q ;
  for (i = 0 ; i < maxtheta ; i++)
    for (j = 0 ; j < maxphi ; j++) { 

      double a,b ;
      double normal[3] ;
      normal[0] = sintheta[i]*cosphi[j] ;
      normal[1] = sintheta[i]*sinphi[j] ;
      normal[2] = costheta[i] ;

      if (dotp(normal,view)<0) {
	unsigned char c = (unsigned char) 0 ;
	fprintf(fp,"%c%c%c",c,c,c) ;
	continue ;
      }
      
      double refl[3] ;
      reflectionvector(normal,view,refl) ;

      a = acos(refl[2])/M_PI*maxtheta ;
      b = atan2(refl[1],refl[0]) ; if (b < 0) b += 2.0*M_PI ;
      b = b/(2.0*M_PI)*maxphi ;
      if (a > maxtheta - 1.0) a = maxtheta - 1.0 ;
      if (b > maxphi - 1.0) b = maxphi - 1.0 ;
      assert (a >= 0 && b >= 0) ;
      
      for (k = 0 ; k < 3 ; k++) {
	double val = 0 ;
	for (p = 0 ; p <= mymaxp ; p++)
	  for (q = -p ; q <= p ; q++) {
	    val += refwarp[(int) a][(int) b][p][q+maxp][k]*Yreal(p,q,th,ph) ;
	  }
	if (val > 255) val = 255 ;
	if (val < 0) val = 0 ;
	unsigned char c = (unsigned char) val ;
	fprintf(fp,"%c",c) ;
      }
    }
  fclose(fp) ;
}

void dumpimages(double refwarp[maxtheta][maxphi][maxp+1][2*maxp+1][3], double imagelist[maxv][maxv][maxtheta][maxphi][3]) {
  int a,b,p,q,i,j,c ;
  int multheta = maxtheta/maxv ;
  int mulphi = maxphi/maxv ;

  for (i = 0 ; i < maxv ; i++) 
    for (a = 0 ; a < maxtheta ; a++)
      for (b = 0 ; b < maxphi ; b++)
	for (q = -mymaxp ; q <= mymaxp ; q++)
	  for (c = 0 ; c < 3 ; c++) 
	    for (p = (q > 0) ? q : -q ; p <= mymaxp ; p++) 
	      imagetmp[i][a][b][q+maxp][c] += refwarp[a][b][p][q+maxp][c] * plmvalreal(p,q,i*multheta) ;

  for (i = 0 ; i < maxv ; i++) 
    for (j = 0 ; j < maxv ; j++)
      for (a = 0 ; a < maxtheta ; a++)
	for (b = 0 ; b < maxphi ; b++)
	  for (c = 0 ; c < 3 ; c++) 
	    for (q = -mymaxp ; q <= mymaxp ; q++)
	      imagelist[i][j][a][b][c] += imagetmp[i][a][b][q+maxp][c] * expreal(q,j*mulphi) ; 
}


//--------------------------------------------------------------------------

main(int argc, char ** argv) {

  struct timeval tv ;
  struct timezone tz ;
  gettimeofday(&tv,&tz) ;
  fprintf(stderr,"Checkpoint1: %ld %ld\n", tv.tv_sec, tv.tv_usec) ;
  
  FILE *fp1, *fp2 ;
  setuplegendre() ;
  readd("Dvalsreal20.out") ;  
  int i,j,k,l,m,p,q,r,s ;

  if (argc != 2) {
    fprintf(stderr,"curetbrdf zercoeffs\n") ;
    exit(1) ;
  }

  gettimeofday(&tv,&tz) ;
  fprintf(stderr,"Checkpoint2: %ld %ld\n", tv.tv_sec, tv.tv_usec) ;

  /*
  mulfac = atof(argv[6]) ;
  
  assert(fp1 = fopen(argv[2],"rt")) ;
  for (l = 0 ; l <= maxl ; l++) 
    for (m = -l ; m <= l ; m++) {
      fscanf(fp1,"%d %d %lf %lf %lf",&i,&j,&(lightcoeffs[l][m+maxl][0]),&(lightcoeffs[l][m+maxl][1]),&(lightcoeffs[l][m+maxl][2])) ;
      assert(i == l) ; assert(j == m) ;
    }
  fclose(fp1) ;
  

  // Light to theta phi 
  double lt = acos(light[2])/M_PI*maxtheta ;
  double lp = atan2(light[1],light[0]) ;
  if (lp < 0) lp += 2.0*M_PI ;
  lp = lp/(2.0*M_PI)*maxphi ;
  if (lt > maxtheta - 1) lt = maxtheta - 1.0 ;
  if (lp > maxphi - 1) lp = maxphi - 1.0 ;
  
  
  for (l = 0 ; l <= maxl ; l++)
    for (m = -l ; m <= l ; m++)
      for (k = 0 ; k < 3 ; k++) {
	lightcoeffs[l][m+maxl][k] = Yreal(l,m,lt,lp) ;
      }
  
  double view[3] ;
  view[0] = atof(argv[3]) ; view[1] = atof(argv[4]) ; view[2] = atof(argv[5]);
  */
  int sampnum, col ;
  assert(fp1 = fopen(argv[1],"rt")) ;

  for (sampnum = 1 ; sampnum <= numsamps ; sampnum++) {
    for (col = 0 ; col < 3 ; col++) {
      for (l = 0 ; l <= zmaxl ; l++)
	for (r = l ; r <= zmaxl ; r++)
	  for (s = 0 ; s <= zmaxl ; s++) {
	     if (s > r || s > l || ((l+s)%2 == 1) || ((r+s)%2 == 1)) continue ;
	     assert(fscanf(fp1,"%lf",&(zercoeffs[sampnum][l][r][s][col]))) ;
	  }
    }
  }
  fclose(fp1) ;

  /*
  char name[300] ;
  sprintf(name,"%sp.ppm",argv[1]) ;
  assert(fp1 = fopen(name,"rb")) ;
  sprintf(name,"%sq.ppm",argv[1]) ;
  assert(fp2 = fopen(name,"rb")) ;
  fscanf(fp1,"%*s %*d %*d %*d%*c") ;
  fscanf(fp2,"%*s %*d %*d %*d%*c") ;

  for (i = 0 ; i < width ; i++)
    for (j = 0 ; j < width ; j++)
      for (k = 0 ; k < 3 ; k++) {
	fscanf(fp1,"%c",&(krylonp[i][j][k])) ;
	fscanf(fp2,"%c",&(krylonq[i][j][k])) ;
      }
  */
  double brdfnorm[3] = {0,0,0} ;
  for (i = 0 ; i < maxtheta ; i++) {
    for (j = 0 ; j < maxtheta ; j++)
      for (k = 0 ; k < maxphi ; k++) {

	double thetain, thetaout, phi ;
	thetain = M_PI*i/maxtheta ;
	thetaout= M_PI*j/maxtheta ;
	phi = 2.0*M_PI*k/maxphi ;

	double posn[3][3] ;
	double L[3], N[3], R[3], V[3], H[3] ;
	double Lnorm[3], Vnorm[3], Hnorm[3] ;

	
	R[0] = 0 ; R[1] = 0 ; R[2] = 1.0 ;
	
	V[0] = sin(thetaout) ; V[1] = 0 ; V[2] = cos(thetaout) ;
	
	N[0] = sin(thetaout/2) ; N[1] = 0 ; N[2] = cos(thetaout/2) ;

	posn[2][0] = N[0] ; posn[2][1] = 0 ; posn[2][2] = N[2] ;
	posn[1][0] = 0 ; posn[1][1] = 1.0 ; posn[1][2] = 0 ; 
	posn[0][0] = N[2] ; posn[0][1] = 0 ; posn[0][2] = -N[0] ;
	
	L[0] = sin(thetain)*cos(phi) ;
	L[1] = sin(thetain)*sin(phi) ;
	L[2] = cos(thetain) ;

	double norm = 0 ;
	int t ;
	for (t = 0 ; t < 3 ; t++) { 
	  H[t] = L[t] + V[t] ;
	  norm = norm + H[t]*H[t] ;	  
	}
	norm = sqrt(norm) ;
	for (t = 0 ; t < 3 ; t++) {
	  H[t] /= norm ;
	}

	for (l = 0 ; l < 3 ; l++) {
	  Lnorm[l] = dotp(L,posn[l]) ;
	  Vnorm[l] = dotp(V,posn[l]) ;
	  Hnorm[l] = dotp(H,posn[l]) ;
	}

	double NdotV, NdotH, NdotL ;
	NdotV = dotp(N,V) ;
	NdotH = dotp(N,H) ;
	NdotL = dotp(N,L) ;
	if (fabs(NdotH)>1.0) NdotH *= 0.999 ;
	double thetah = acos(NdotH) ;
	assert(NdotV >= 0) ;
	

	/*
	N[0] = 0 ; N[1] = 0 ; N[2] = 0 ;
	posn[2][0] = N[0] ; posn[2][1] = 0 ; posn[2][2] = N[2] ;
	posn[1][0] = 0 ; posn[1][1] = 1.0 ; posn[1][2] = 0 ; 
	posn[0][0] = N[2] ; posn[0][1] = 0 ; posn[0][2] = -N[0] ;

	L[0] = sin(thetain)*cos(phi) ;
	L[1] = sin(thetain)*sin(phi) ;
	L[2] = cos(thetain) ;

	V[0] = sin(thetaout) ; V[1] = 0 ; V[2] = cos(thetaout) ;
	*/


	if (NdotL < 0)
	  valbrdf[i][j][k] = 0  ;
	//	if (thetain > M_PI/2 || thetaout > M_PI/2) 
	//	  valbrdf[i][j][k] = 0  ;
	  else {
	    valbrdf[i][j][k] = 1 ;
	    
	    double tinorm, tonorm, pinorm, ponorm, pnorm ;
	    tinorm = thetain ; tonorm = thetaout ; pnorm = phi ;
	    
	    findangles(Lnorm,tinorm, pinorm) ;
	    findangles(Vnorm,tonorm, ponorm) ;
	    pnorm = ponorm - pinorm ; if (pnorm < 0) pnorm += 2.0*M_PI ;
	    
	    double ci = cos(tinorm) ;
	    
	    double val = 0 ;
	    int ll ;
	    double ti,to,p ;
	    ti = tinorm/(M_PI/2.0)*maxtheta ;
	    if (ti > maxtheta - 1) ti = maxtheta - 1 ;
	    to = tonorm/(M_PI/2.0)*maxtheta ;
	    if (to > maxtheta - 1) to = maxtheta - 1 ;
	    p = pnorm/(2.0*M_PI)*maxphi ;
	    if (p > maxphi - 1) p = maxphi - 1 ;

	    int ctr = 0 ;
	    for (ll = 0 ; ll <= zmaxl ; ll++)
	      for (r = ll ; r <= zmaxl ; r++)
		for (s = 0 ; s <= zmaxl ; s++) {
		  if (s > r || s > ll || ((ll+s)%2 == 1) || ((r+s)%2 == 1)) continue ;
		  zvals[i][j][k][ctr] =  Zrealiso(ll,r,s,p,ti,to)*ci ;
		  if (ll != r) zvals[i][j][k][ctr] += Zrealiso(r,ll,s,p,ti,to)*ci ;
		  ++ctr ;
		}
	    assert(ctr == 55) ;
 	  }
      }
    fprintf(stderr,"%d ",i) ;
  }
  fprintf(stderr,"\n") ;
  
  for (sampnum = 1 ; sampnum <= numsamps ; sampnum++) {
    for (l = 0 ; l < 3 ; l++) {
      brdfnorm[l] = 0 ;
      for (i = 0 ; i < maxtheta ; i++) {
      for (j = 0 ; j < maxtheta ; j++) {

	double thetain, thetaout, phi ;
	thetain = M_PI*i/maxtheta ;
	thetaout= M_PI*j/maxtheta ;
	double dtheta1, dtheta2, dphi ;
	dtheta1 = dtheta2 = M_PI/maxtheta ;
	dphi = 2.0*M_PI/maxphi ;
	double si, so ;
	si = sin(thetain) ; so = sin(thetaout) ;

	for (k = 0 ; k < maxphi ; k++) {
	  brdf[l][i][j][k] = 0 ;
	    if (valbrdf[i][j][k]) {
	      int ctr = 0 ;
	      for (int ll = 0 ; ll <= zmaxl ; ll++)
		for (r = ll ; r <= zmaxl ; r++)
		  for (s = 0 ; s <= zmaxl ; s++) {
		    if (s > r || s > ll || ((ll+s)%2 == 1) || ((r+s)%2 == 1)) continue ;
		    brdf[l][i][j][k] += 
		      zvals[i][j][k][ctr]*zercoeffs[sampnum][ll][r][s][l];
		    ++ctr ;
		  }
	      assert(ctr == 55) ;
	    }
	  brdfnorm[l] += si*so*dtheta1*dtheta2*dphi*brdf[l][i][j][k]*brdf[l][i][j][k] ;	    
	}
      }
      //      fprintf(stderr,"%d ",i) ;
      }
    }
    printf("%d ",sampnum) ;
    //    fprintf(stderr,"\nSample number: %d\n",sampnum) ;
    //    fprintf(stderr,"BRDF norm is %lf %lf %lf\n",brdfnorm[0],brdfnorm[1],brdfnorm[2]) ;

    for (i = 0 ; i < 3 ; i++) findcoeffs(brdf[i],brdfcoeffs[i]) ;

    double coeffnorm[3] = {0,0,0} ;
    double fracerr = 0 ;
    for (j = 0 ; j <= maxp ; j++) {	
	for (k = 0 ; k <= maxp ; k++) 
	  for (i = 0 ; i <= maxl ; i++) {
	    if (k > j || k > i) continue ;
	    for (l = 0 ; l < 3 ; l++) 
	      coeffnorm[l] += brdfcoeffs[l][i][j][k]*brdfcoeffs[l][i][j][k] ;
	  }	
	for (l = 0 ; l < 3 ; l++) 
	  if (coeffnorm[l]/brdfnorm[l] > fracerr) fracerr = coeffnorm[l]/brdfnorm[l] ;
	printf("%lf ",fracerr) ;
    }
    printf("\n") ; fflush(stdout) ;
    /*
    double coeffnorm[3] = {0,0,0} ;
    int mymaxlflag[3] = {0,0,0} ;
    int mymaxpflag[3] = {0,0,0} ;

    for (l = 0 ; l < 3 ; l++) {
      for (j = 0 ; j <= maxp ; j++)	
	for (k = 0 ; k <= maxp ; k++) 
	  for (i = 0 ; i <= maxl ; i++) {
	    if (k > j || k > i) continue ;
	    coeffnorm[l] += brdfcoeffs[l][i][j][k]*brdfcoeffs[l][i][j][k] ;
	    if (coeffnorm[l]/brdfnorm[l] > 0.98 && mymaxpflag[l] == 0) {
	      mymaxpflag[l] = j ;
	    }
	  }
    }
    fprintf(stderr,"Coefficient norm is %lf %lf %lf Percentage accuracy is %lf %lf %lf mymaxp is %d %d %d\n",coeffnorm[0],coeffnorm[1],coeffnorm[2],100.0*coeffnorm[0]/brdfnorm[0],100.0*coeffnorm[1]/brdfnorm[1],100.0*coeffnorm[2]/brdfnorm[2],mymaxpflag[0],mymaxpflag[1],mymaxpflag[2]) ;

    for (l = 0 ; l < 3 ; l++) {
      coeffnorm[l] = 0 ;
      for (i = 0 ; i <= maxl ; i++)
	for (j = 0 ; j <= mymaxpflag[l] ; j++)
	  for (k = 0 ; k <= mymaxpflag[l] ; k++) {
	    if (k > j || k > i) continue ;
	    coeffnorm[l] += brdfcoeffs[l][i][j][k]*brdfcoeffs[l][i][j][k] ;
	    if (coeffnorm[l]/brdfnorm[l] > 0.98 && mymaxlflag[l] == 0) {
	      mymaxlflag[l] = i ;
	  }
	  }
    }
    fprintf(stderr,"Coefficient norm is %lf %lf %lf mymaxl is %d %d %d\n",coeffnorm[0],coeffnorm[1],coeffnorm[2],mymaxlflag[0],mymaxlflag[1],mymaxlflag[2]) ;	 
  }
    */
  }
}
