function showFaceVectorField(X,T,vf,h)

if nargin < 4
    h = figure;
end

Xm = (X(T(:,1),:)+X(T(:,2),:)+X(T(:,3),:))/3;

%patch('Faces',T,'Vertices',X,'FaceColor','k','EdgeColor','none'); 
showPerVertexFunction(X, T, ones(size(X,1),1), h);
colorbar off;
axis equal; axis off;
cameratoolbar; 
hold on;

r = randperm(length(T));
m = round(length(T)); % may want length(T)/3 for 2r.off
ts = r(1:m);
quiver3(Xm(ts,1),Xm(ts,2),Xm(ts,3),vf(ts,1),vf(ts,2),vf(ts,3),'k');