% Load data and construct DEC matrices
[X,T] = readOff('torusr.off'); % also try 2r.off
DEC = discreteExteriorCalculus(X,T);

% Construct a vector field for testing (pretty arbitrary VF)
midpoint = (X(T(:,1),:)+X(T(:,2),:)+X(T(:,3),:))/3;
%omega = DEC.d01*X(:,2)+DEC.star1D1*DEC.d12'*(midpoint(:,2)*5); % for testing 2r.off
omega = DEC.d01*X(:,2)+DEC.d12'*midpoint(:,3); % for testing both models
vf = oneFormToVF(X,T,DEC,omega);
showFaceVectorField(X,T,vf);

% Compute Helmholtz-Hodge decomposition
[ divergenceFree curlFree harmonic ] = helmholtzHodge(DEC,omega);

fprintf('This number should be zero for genus 0 surfaces: %g\n', norm(harmonic));
fprintf('This number should always be zero: %g\n', norm(omega-divergenceFree-curlFree-harmonic));

h = subplot(1,4,1);
vf = oneFormToVF(X,T,DEC,omega);
showFaceVectorField(X,T,vf,h);
title('Original vector field');

h = subplot(1,4,2);
vf = oneFormToVF(X,T,DEC,divergenceFree);
showFaceVectorField(X,T,vf,h);
title('Divergence-free part');

h = subplot(1,4,3);
vf = oneFormToVF(X,T,DEC,curlFree);
showFaceVectorField(X,T,vf,h);
title('Curl-free part');

h = subplot(1,4,4);
vf = oneFormToVF(X,T,DEC,harmonic);
showFaceVectorField(X,T,vf,h);
title('Harmonic part');