function [U,Xm] = oneFormToVF(X, T, DEC, omega, barycentric)
% Converts one forms to per-face vector fields using Whitney forms.

if nargin < 5
    barycentric = [1,1,1];
end

t2e = DEC.t2e;

N = cross(X(T(:,1),:)-X(T(:,2),:), X(T(:,1),:) - X(T(:,3),:));
Ar = rowNorms(N)/2;

nf = length(T);

w = omega(abs(t2e)).*sign(t2e);

P1 = X(T(:,3),:) - X(T(:,2),:);
P2 = X(T(:,1),:) - X(T(:,3),:);
P3 = X(T(:,2),:) - X(T(:,1),:);

P1r = cross(P1,N,2);
P2r = cross(P2,N,2);
P3r = cross(P3,N,2);

barycentric = barycentric/sum(barycentric); bo=barycentric; barycentric = repmat(barycentric, nf, 1);

U = repmat(w(:,2).*barycentric(:,3) - w(:,3).*barycentric(:,2),1,3).*P1r + ...
    repmat(w(:,3).*barycentric(:,1) - w(:,1).*barycentric(:,3),1,3).*P2r + ...
    repmat(w(:,1).*barycentric(:,2) - w(:,2).*barycentric(:,1),1,3).*P3r;
U = U./repmat(2*Ar,1,3);

Xm = X(T(:,1),:)*bo(1) + X(T(:,2),:)*bo(2) + X(T(:,3),:)*bo(3);