% Read mesh -- our input has consistent orientation
[X,T] = readOff('166.off');

% Jumble up orientations of triangles, preserving first row
for i=2:size(T,1)
    T(i,:) = T(i,randperm(3));
end

% Render the bad mesh -- notice that the triangles are bad!
showMesh(X,T);

% Fix the bad mesh
T = assignCoherentOrientation(T);

% Now the mesh looks right!
showMesh(X,T);