function [dEdgesToTriangles dVerticesToEdges E] = boundaryOperators(T)
% Takes an oriented triangle mesh and computes two operators
% that should be stored as /sparse/ matrices:
%    dTrianglesToEdges -- Matrix in R^{t x e} that takes one value per 
%       edge and returns one value per triangle by combining adjacent
%       edge values with coefficient +1 when the edge and triangle have
%       same orientation and -1 otherwise.
%    dVerticesToEdges -- Similar, with +1 at the head of each edge
%       and -1 at the tail of each edge (size R^{e x v})
% This requires orienting the edges of the mesh, so the third
% returned variable is a list of oriented edges between vertices 
% of size e x 2 in format [v1 v2 ; v1 v2 ; ...] where an oriented
% edge is given by v1 -> v2.
