nSamples = 101;
nSteps = 2000;
timeStep = .1;

%% Set up an interesting parametric graph

t0 = 0;
t1 = pi*1.25;

% We provide a few examples of curves to try
%curveFunction = @(t) [(cos(t)-cos(3*t).^3); (sin(t)-sin(3*t).^3)]';
%curveFunction = @(t) [cos(t);sin(t)]';
curveFunction = @(t) [t;(t-t0).*(t1-t)]';
curve = curveFunction(linspace(t0,t1,nSamples));

% PART (b) -- UNCOMMENT THE CODE BELOW %%%%%%
% evil curve
% tVals = linspace(t0,t1,nSamples);
% curve(1:2:nSamples,1) = -1;
% curve(2:2:nSamples,1) = 1;
% curve(1:2:nSamples,2) = -1;
% curve(2:2:nSamples,2) = 1;
% curve(1,:) = 0;
% curve(nSamples,:) = 0;
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

plotCurve(curve);
axis equal;
axisData = axis;
close all;

%% Time step

f = figure;
for i=1:nSteps
    % PART (a) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    plotCurve(curve,f); 
    axis(axisData);
    drawnow;
end