nSamples = 101;

%% Set up an interesting parametric graph

t0 = 0;
t1 = 4*pi;

% Try other curve shapes!
curveFunction = @(t) [t;cos(t);sin(2*t)]';
curve = curveFunction(linspace(t0,t1,nSamples));

%% Compute the Bishop frame

k = size(curve,1)-1;
binormal = zeros(nSamples-2,3);

% PART (a) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

k = size(curve,1)-1;
plot3(curve(:,1),curve(:,2),curve(:,3),'k','linewidth',3,'linesmoothing','on');
axis equal;
hold on;
quiver3(curve(2:k,1),curve(2:k,2),curve(2:k,3),binormal(:,1),binormal(:,2),binormal(:,3),'b');
title('Binormal');

%% Animate spinning Bishop frame

% Doesn't work if initial segment is parallel to z...
d = curve(2,:) - curve(1,:);
t0 = d/norm(d);
frame0 = cross(t0,[0,0,1]);
frame0 = frame0 / norm(frame0);
frame1 = cross(t0,frame0);

midpoints = (curve(1:(size(curve,1)-1),:) + curve(2:size(curve,1),:))/2;
fig = figure;
for i=1:10
    for degrees=1:360
        theta = degrees * pi / 180;
        
        u = zeros(nSamples-1,3);
        v = zeros(nSamples-1,3);
        
        u(1,:) = cos(theta)*frame0+sin(theta)*frame1;
        v(1,:) = -sin(theta)*frame0+cos(theta)*frame1;
        
        % PART (b) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        clf(fig);
        plot3(curve(:,1),curve(:,2),curve(:,3),'k','linewidth',3,'linesmoothing','on');
        axis equal;
        hold on

        quiver3(midpoints(:,1),midpoints(:,2),midpoints(:,3),u(:,1),u(:,2),u(:,3),'r');
        quiver3(midpoints(:,1),midpoints(:,2),midpoints(:,3),v(:,1),v(:,2),v(:,3),'b');
        
        title('Bishop frame');
        
        drawnow;
    end
end