##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

my %params;

while (<>) {
    if (/^(\S+)\s+(GL_\S+)\s+(.*)\s*$/) {
 
	my $type   = $1;
	my $pname  = $2;
	my @params = split /\s+/, $3;

	$params{$pname}->{'type'} = $type;
	$params{$pname}->{'params'} = \@params;
    }
    elsif ( /^\s*$/ ) {
    }
    elsif ( /^\s*\#/ ) {
    }
    else {
	die "line $. confuses me: $_";
    }
}

binmode STDOUT;

print <<EOF;
/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "glcontext.h"
#include "glerror.h"

EOF

$header = <<EOF;
{
    GLcontext   *g = GetCurrentContext( );

	if (g->current.beginend)
		if (__glerror(__LINE__, __FILE__, GL_INVALID_OPERATION, "glGet called in Begin/End"))
			return 0;

    switch ( pname ) {

EOF

 printf ("\n");
 printf ("GLboolean GLSTATE_DECL\n");
 printf ("__glstate_IsEnabled( GLenum pname)\n");
 print   $header;
  
 foreach $pname (sort(keys(%params))) {
    printf ("      case %s:\n", $pname);
    printf ("        return $params{$pname}->{'params'}[0];\n");
    printf ("\n");
  }
  
  print "      default:\n";
  print "		if (__glerror(__LINE__, __FILE__, GL_INVALID_ENUM, \"glIsEnabled: Unknown enum: %d\", pname))\n";
  print "				return 0;\n";
  print "    }\n";
  print "  return 0;\n";
  print "}\n";

print <<EOF;

/* this file auto-generated by glisenabled.pl */
EOF
