/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "glcontext.h"
#include "glerror.h"


GLboolean GLSTATE_DECL
__glstate_IsEnabled( GLenum pname)
{
    GLcontext   *g = GetCurrentContext( );

	if (g->current.beginend)
		if (__glerror(__LINE__, __FILE__, GL_INVALID_OPERATION, "glGet called in Begin/End"))
			return 0;

    switch ( pname ) {

      case GL_ALPHA_TEST:
        return g->buffer.alphatest;

      case GL_BLEND:
        return g->buffer.blend;

      case GL_CLIP_PLANE0:
        return g->trans.clip[0];

      case GL_CLIP_PLANE1:
        return g->trans.clip[1];

      case GL_CLIP_PLANE2:
        return g->trans.clip[2];

      case GL_CLIP_PLANE3:
        return g->trans.clip[3];

      case GL_CLIP_PLANE4:
        return g->trans.clip[4];

      case GL_CLIP_PLANE5:
        return g->trans.clip[5];

      case GL_COLOR_MATERIAL:
        return GL_FALSE;

      case GL_CULL_FACE:
        return g->polygon.cullface;

      case GL_DEPTH_TEST:
        return g->buffer.depthtest;

      case GL_DEPTH_WRITEMASK:
        return g->buffer.depthmask;

      case GL_FOG:
        return g->fog.enable;

      case GL_LIGHT0:
        return g->lighting.light[0].enable;

      case GL_LIGHT1:
        return g->lighting.light[1].enable;

      case GL_LIGHT2:
        return g->lighting.light[2].enable;

      case GL_LIGHT3:
        return g->lighting.light[3].enable;

      case GL_LIGHT4:
        return g->lighting.light[4].enable;

      case GL_LIGHT5:
        return g->lighting.light[5].enable;

      case GL_LIGHT6:
        return g->lighting.light[6].enable;

      case GL_LIGHT7:
        return g->lighting.light[7].enable;

      case GL_LIGHTING:
        return g->lighting.lighting;

      case GL_LINE_SMOOTH:
        return g->line.linesmooth;

      case GL_LINE_STIPPLE:
        return g->line.linestipple;

      case GL_NORMALIZE:
        return g->current.normalize;

      case GL_PACK_LSB_FIRST:
        return g->pixel.packlsbfirst;

      case GL_PACK_SWAP_BYTES:
        return g->pixel.packswapbytes;

      case GL_POINT_SMOOTH:
        return g->line.pointsmooth;

      case GL_POLYGON_SMOOTH:
        return g->polygon.polygonsmooth;

      case GL_POLYGON_STIPPLE:
        return g->polygon.polygonstipple;

      case GL_RGBA_MODE:
        return GL_TRUE;

      case GL_TEXTURE_1D:
        return g->texture.enabled1d;

      case GL_TEXTURE_2D:
        return g->texture.enabled2d;

      case GL_TEXTURE_3D:
        return g->texture.enabled3d;

      case GL_TEXTURE_GEN_Q:
        return g->texture.texturegen.q;

      case GL_TEXTURE_GEN_R:
        return g->texture.texturegen.p;

      case GL_TEXTURE_GEN_S:
        return g->texture.texturegen.s;

      case GL_TEXTURE_GEN_T:
        return g->texture.texturegen.t;

      case GL_UNPACK_LSB_FIRST:
        return g->pixel.unpacklsbfirst;

      case GL_UNPACK_SWAP_BYTES:
        return g->pixel.unpackswapbytes;

      default:
		if (__glerror(__LINE__, __FILE__, GL_INVALID_ENUM, "glIsEnabled: Unknown enum: %d", pname))
				return 0;
    }
  return 0;
}

/* this file auto-generated by glisenabled.pl */
