/* CS348C PROGRAMMING ASSIGNMENT 1: SIMPLIFIED MOTIF INTERFACE.

Copyright (c) 1995 The Board of Trustees of The Leland Stanford Junior
University. All rights reserved.

Permission to use, copy, modify and distribute this software for any
purpose is hereby granted without fee, provided that the above
copyright notice and this permission notice appear in all copies of
this software and that you do not sell the software.  Commercial
licensing is available by contacting the author.

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.

Author:
   Apostolos Lerios
   Computer Science Department
   Stanford University
   U.S.A.
   http://graphics.stanford.edu/~tolis/ */


#include "xsupport.h"
#include <stdio.h>
#include <math.h>
#include <Xm/PushB.h>
#include <Xm/Scale.h>
#include <Xm/FileSB.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelG.h>
#include <Xm/ToggleB.h>
#include <Xm/Protocols.h>


/* PUSH BUTTON MOTIF CALLBACK. */

/* Calls the user-defined callback function. */

void PushButtonPrecallback(Widget,
			   PushButton *B,
			   void *) {

  (*(B->Callback))(B->UserData);
}


/* PUSH BUTTON METHOD. */

PushButton::PushButton(Widget Parent,
		       char *Name,
		       PushButtonCallback NewCallback,
		       void *NewUserData)
: Callback(NewCallback), UserData(NewUserData) {

  Widget B=XtVaCreateManagedWidget(Name,xmPushButtonWidgetClass,Parent,
				   NULL);
  XtAddCallback(B,XmNactivateCallback,XtCallbackProc(PushButtonPrecallback),
		XtPointer(this));
}


/* DIALOG BUTTON MOTIF CALLBACKS. */

/* Pops up the file dialog associated with a dialog button. */

static void ShowFileDialog(Widget,
                           Widget FileDialog,
                           void *) {

  XtManageChild(FileDialog);
}

/* Hides the file dialog associated with a dialog button. */

static void HideFileDialog(Widget,
                           Widget FileDialog,
                           void *) {

  XtUnmanageChild(FileDialog);
}

/* Calls the user-defined callback function after extracting the
selected file name. */

static void DialogButtonPrecallback(Widget FileDialog,
                                    DialogButtonCallback Callback,
                                    XmFileSelectionBoxCallbackStruct *CbS) {

  /* Retrieve file name. */

  char *FileName;
  XmStringGetLtoR(CbS->value,XmSTRING_DEFAULT_CHARSET,&FileName);

  /* No file has been selected. */

  if (!(*FileName))
    return;

  /* In case the user has not specified the directory, we must supply it. */

  char *FileSpec;
  if ((*FileName)!='/') {
    char *Path;
    if (!XmStringGetLtoR(CbS->dir,XmSTRING_DEFAULT_CHARSET,&Path))
      return;
    FileSpec=XtMalloc(strlen(Path)+1+strlen(FileName)+1);
    sprintf(FileSpec,"%s/%s",Path,FileName);
    XtFree(Path);
    XtFree(FileName);
  } else
    FileSpec=FileName;

  /* Invoke user callback. */

  (*Callback)(FileSpec);

  /* Cleanup. */

  XtFree(FileSpec);
  XtUnmanageChild(FileDialog);
}


/* DIALOG BUTTON METHOD. */

DialogButton::DialogButton(Widget Parent,
			   char *Name,
			   char *Message,
			   DialogButtonCallback Callback) {

  // Create button.

  Widget B=XtVaCreateManagedWidget(Name,xmPushButtonWidgetClass,Parent,
				   NULL);

  // Find top level ancestor of parent.

  Widget Shell=Parent;
  while ((XtClass(Shell)!=applicationShellWidgetClass) &&
	 (XtClass(Shell)!=topLevelShellWidgetClass))
    Shell=XtParent(Shell);

  // Create file selection dialog.

  Widget FileDialog=XmCreateFileSelectionDialog(Shell,"",NULL,0);
  XmString Str1=XmStringCreateSimple(Message);
  XmString Str2=XmStringCreateSimple("File Selection");
  XtVaSetValues(FileDialog,
		XmNselectionLabelString,Str1,
		XmNdialogTitle,Str2,
		NULL);
  XmStringFree(Str2);
  XmStringFree(Str1);
  XtVaSetValues(XtParent(FileDialog),
		XmNdeleteResponse,XmDO_NOTHING,
		NULL);
  XmAddWMProtocolCallback(XtParent(FileDialog),
			  XmInternAtom(XtDisplay(Parent),
				       "WM_DELETE_WINDOW",False),
			  XtCallbackProc(HideFileDialog),
			  caddr_t(FileDialog));
  XtAddCallback(FileDialog,XmNokCallback,
		XtCallbackProc(DialogButtonPrecallback),XtPointer(Callback));
  XtAddCallback(FileDialog,XmNcancelCallback,
		XtCallbackProc(HideFileDialog),caddr_t(FileDialog));
  XtUnmanageChild(XmFileSelectionBoxGetChild(FileDialog,
					     XmDIALOG_HELP_BUTTON));
  
  // Attach dialog to button.
  
  XtAddCallback(B,XmNactivateCallback,
		XtCallbackProc(ShowFileDialog),XtPointer(FileDialog));
}


/* SLIDER MOTIF CALLBACK. */

/* Calls the user-defined callback function after calculating the
slider value. */

void SliderPrecallback(Widget,
		       Slider *S,
		       void *) {

  short Decimals;
  int Value;
  XtVaGetValues(S->Handle,
                XmNvalue,&Value,
                XmNdecimalPoints,&Decimals,
                NULL);
  (*(S->Callback))(Value/pow(10,Decimals),S->UserData);
}


/* SLIDER METHODS. */

Slider::Slider(Widget Parent,
	       char *Name,
	       int Minimum,
	       int Maximum,
	       int InitialValue,
	       short Decimals,
	       SliderCallback NewCallback,
	       void *NewUserData)
: Callback(NewCallback), UserData(NewUserData) {

  XmString Str=XmStringCreateSimple(Name);
  Handle=XtVaCreateManagedWidget("",xmScaleWidgetClass,Parent,
				 XmNmaximum,Maximum,
				 XmNminimum,Minimum,
				 XmNdecimalPoints,Decimals,
				 XmNvalue,InitialValue,
				 XmNorientation,XmHORIZONTAL,
				 XmNtitleString,Str,
				 XmNshowValue,True,
				 NULL);
  XtAddCallback(Handle,XmNvalueChangedCallback,
		XtCallbackProc(SliderPrecallback),XtPointer(this));
  XmStringFree(Str);
}

void Slider::SetValue(int Value) const {

  XtVaSetValues(Handle,
                XmNvalue,Value,
                NULL);
}


/* CHOICE BUTTON SET MOTIF CALLBACK. */

/* Calls the user-defined callback function. */

static void ChoiceButtonPrecallback(Widget,
                                    ChoiceButtonCallback Callback,
                                    XmToggleButtonCallbackStruct *CbS) {

  (*Callback)(CbS->set);
}


/* CHOICE BUTTON SET METHODS. */

ChoiceButtonSet::ChoiceButtonSet(Widget Parent,
				 char *Name,
				 int Radio) {

  Row=XtVaCreateManagedWidget("",xmRowColumnWidgetClass,Parent,
			      XmNorientation,XmHORIZONTAL,
			      XmNradioBehavior,Radio,
			      NULL);
  XtVaSetValues(Row,
		XmNisHomogeneous,False,
		XmNpacking,XmPACK_TIGHT,
		NULL);
  XtVaCreateManagedWidget(Name,xmLabelGadgetClass,Row,
			  NULL);
}

void ChoiceButtonSet::AddButton(char *Name,
				int On,
				ChoiceButtonCallback Callback) const {

  Widget B=XtVaCreateManagedWidget(Name,xmToggleButtonWidgetClass,Row,
				   NULL);
  XtVaSetValues(B,
		XmNset,On,
		NULL);
  XtAddCallback(B,XmNvalueChangedCallback,
		XtCallbackProc(ChoiceButtonPrecallback),XtPointer(Callback));
}
