#include <stdio.h>
#include <iostream>
#include <fstream>
#include <time.h>

using namespace std;

#define INFILE_NAME "surface.dat"
#define HIST_NAME "surface.hist"
#define PBRT_NAME1 "surface1.pbrt"
#define PBRT_NAME2 "surface2.pbrt"

ifstream infile;
ofstream outfile1;
ofstream outfile2;

#define MAX_COUNT 3000

#define START 5
#define STOP 80

#define START_RADIUS 0.2f
#define STOP_RADIUS 1.0f

#define START_P 0.0f
#define STOP_P 0.4f
#define MAX_P 0.7f


int hist[MAX_COUNT];
int maxCount, maxIndex;

/*
void Read()
{
	char buf[256];

	infile.open(INFILE_NAME);
	while (!infile.getline(buf, 256).eof()) {
		float x, y, z;
		int count;
		sscanf(buf, "%f %f %f %d", &x, &y, &z, &count);

		hist[count]++;
		if (maxCount < hist[count]) {
			maxCount = hist[count];
		}

		if (maxIndex < count) {
			maxIndex = count;
		}
	}
	infile.close();
}

void Hist()
{
	outfile.open(HIST_NAME);
	for (int i = 1; i <= maxIndex; i++) {
		outfile << i << " " <<  hist[i] << endl;
	}
	outfile.close();
}
*/

void Write()
{
	infile.open(INFILE_NAME);
	outfile1.open(PBRT_NAME1);
	outfile2.open(PBRT_NAME2);
	

	char buf[256];
	while (!infile.getline(buf, 256).eof()) {
		float x, y, z, radius, probability;
		int count;

		sscanf(buf, "%f %f %f %d", &x, &y, &z, &count);
		if (count < START) {continue;}
		
		if (count > STOP) {
			radius = STOP_RADIUS;
		}
		else {
			radius = (STOP_RADIUS - START_RADIUS) / (STOP- START) *  (count - START) + START_RADIUS;
		}

		probability = (STOP_P - START_P) / (STOP- START) *  (count - START) + START_P;
		if (probability > MAX_P) { probability = MAX_P;}

		sprintf(buf, "[%f]", radius);


		ofstream *outfile;
		if ((float) rand() / RAND_MAX < probability) {
			outfile = &outfile2;
		}
		else {
			outfile = &outfile1;
		}

		*outfile << "AttributeBegin\n";
		*outfile << "Translate " << x << " " << y << " " << z << endl;
		*outfile << "Shape \"sphere\" \"float radius\" " << buf << endl;
		*outfile << "AttributeEnd\n\n";
	}
	
	outfile1.close();
	outfile2.close();
	infile.close();
}

int main(int argc, char argv[])
{
	//Read();
	//Hist();

	srand( (unsigned)time( NULL ) );

	Write();
}