#include <stdio.h>
#include <iostream>
#include <fstream>
#include <ImfRgbaFile.h>
#include <ImfStringAttribute.h>
#include <ImfMatrixAttribute.h>
#include <ImfArray.h>

using namespace std;
using namespace Imf;

// range -500 500 -700 1000
// assume pixel width = 1
#define ALTITUDE 0
#define MIN_RADIUS 0.1
#define MAX_RADIUS 0.8

#define WIDTH 1000
#define HEIGHT 1700
#define OFFSET_X 500
#define OFFSET_Y 700
#define INFILE_NAME "ground.dat"
#define OUTFILE_NAME "ground.exr"
#define PBRTFILE_NAME "ground.pbrt"

#define AVG_DELTA 0
#define DEFAULT_WEIGHT 20.0f

struct RGBA
{
	half r,g,b,a;
};

ifstream infile;

float count[HEIGHT][WIDTH];
RGBA data[HEIGHT][WIDTH];

float xmin, xmax, ymin, ymax, fmin, fmax, avgmax;

void MinMax(float &min, float &max, float data)
{
	if (data > max) {
		max = data;
	}
	if (data < min) {
		min = data;
	}
}

void Read()
{
	char buf[256];
	infile.open("ground.dat");

	xmin = xmax = ymin = ymax = fmin = fmax = 0;
	while (!infile.getline(buf, 256).eof()) {
		float x, y, z;
		int flowCount, simulCount;
		sscanf(buf, "%f %f %f %d %d", &x, &y, &z, &flowCount, &simulCount);

		int ix = (int) (x + OFFSET_X);
		int iy = (int) (y + OFFSET_Y);

		// weight = DEFAULT + count
		count[iy][ix] += DEFAULT_WEIGHT + flowCount;
		//count[iy][ix] += DEFAULT_WEIGHT;

		MinMax(xmin, xmax, x);
		MinMax(ymin, ymax, y);
		MinMax(fmin, fmax, count[iy][ix]);
	}

	printf("%f %f %f %f %f %f\n", xmin, xmax, ymin, ymax, fmin, fmax);
}

float Clamp(float in)
{
	if (in > 1) {
		return 1.0f;
	}
	else {
		return in;
	}
}

float GetCount(int i, int j)
{
	if (i < 0) {
		i = 0;
	}
	else if (i >= WIDTH) {
		i = WIDTH - 1;
	}

	if (j < 0) {
		j = 0;
	}
	else if (j >= HEIGHT) {
		j = HEIGHT - 1;
	}

	return count[j][i];
}

float Average(int i, int j)
{
	int count = 0;
	float sum = 0;
	for (int dy = - AVG_DELTA; dy <= AVG_DELTA; dy++) {
		for (int dx = - AVG_DELTA; dx <= AVG_DELTA; dx++) {
			count++;
			sum += GetCount(i + dx, j + dy);
		}
	}
	float avg = sum / count;
	float dummy;
	MinMax(dummy, avgmax, avg);
	return avg;
}

void Construct()
{
	/* log scale */
	for (int j = 0; j < HEIGHT; j++) {
		for (int i = 0; i < WIDTH; i++) {
			if (count[j][i]) {
				count[j][i] = (log(count[j][i]));
			}
		}
	}


	for (int j = 0; j < HEIGHT; j++) {
		for (int i = 0; i < WIDTH; i++) {
			float avg = Average(i, j);
			data[j][i].a = avg;
			//data[j][i].a = Clamp(avg);
			//if (data[j][i].a > 1) printf("%f\n", Average(i,j));
		}
	}

	printf("avg max:%f\n", avgmax);

	for (int j = 0; j < HEIGHT; j++) {
		for (int i = 0; i < WIDTH; i++) {
			//data[j][i].r = data[j][i].g = data[j][i].b = data[j][i].a;
			data[j][i].r = data[j][i].g = data[j][i].b = data[j][i].a = data[j][i].a / avgmax;
		}
	}
}

void Write()
{
	RgbaOutputFile file(OUTFILE_NAME, WIDTH, HEIGHT, WRITE_RGBA);
	file.setFrameBuffer ((Rgba *)data, 1, WIDTH);
    file.writePixels (HEIGHT);
}

void Write2()
{
	ofstream outfile;
	outfile.open(PBRTFILE_NAME);

	for (int j = 0; j < HEIGHT; j++) {
		for (int i = 0; i < WIDTH; i++) {

			float weight = data[j][i].a;
			if (weight == 0) {continue;}
	
			float radius = weight * MAX_RADIUS;
			if (radius < MIN_RADIUS) { radius = MIN_RADIUS;}
			char buf[256];
			sprintf(buf, "[%f]", radius);

			outfile << "AttributeBegin\n";
			outfile << "Translate " << (i - OFFSET_X) << " " << (j - OFFSET_Y) << " " << ALTITUDE << endl;
			outfile << "Shape \"sphere\" \"float radius\" " << buf << endl;
			outfile << "AttributeEnd\n\n";
		}
	}
	outfile.close();
}

int main(int argc, char argv[])
{
	Read();
	Construct();
	//Write();
	Write2();
}